/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.text.ParseException;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;

public class CharacterFormatFactory
extends AbstractFormatFactory {
    private final CharacterFormat characterFormat = new CharacterFormat();

    public CharacterFormatFactory() {
        this.supportedClasses.add(Character.TYPE);
        this.supportedClasses.add(Character.class);
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return this.characterFormat;
    }

    private static class CharacterFormat
    implements Format<Character> {
        private CharacterFormat() {
        }

        @Override
        public String format(Character object) throws Exception {
            return object.toString();
        }

        @Override
        public Character parse(String string) throws Exception {
            if (string.length() > 1) {
                throw new ParseException("The string \"" + string + "\" cannot be parsed to a character (size > 1).", 1);
            }
            return Character.valueOf(string.charAt(0));
        }
    }
}

