/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.DynamicRouter;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.InOnly;
import org.apache.camel.InOut;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Pattern;
import org.apache.camel.Processor;
import org.apache.camel.RecipientList;
import org.apache.camel.RoutingSlip;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.StreamCache;
import org.apache.camel.component.bean.BeanHelper;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterBindingException;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.spi.ErrorHandlerAware;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MethodInfo.class);
    private final CamelContext camelContext;
    private final Class<?> type;
    private final Method method;
    private final List<ParameterInfo> parameters;
    private final List<ParameterInfo> bodyParameters;
    private final boolean hasCustomAnnotation;
    private final boolean hasHandlerAnnotation;
    private final Expression parametersExpression;
    private ExchangePattern pattern = ExchangePattern.InOut;
    private AsyncProcessor recipientList;
    private AsyncProcessor routingSlip;
    private AsyncProcessor dynamicRouter;

    public MethodInfo(CamelContext camelContext, Class<?> type, Method method, List<ParameterInfo> parameters, List<ParameterInfo> bodyParameters, boolean hasCustomAnnotation, boolean hasHandlerAnnotation) {
        RecipientList recipientListAnnotation;
        DynamicRouter dynamicRouterAnnotation;
        RoutingSlip routingSlipAnnotation;
        this.camelContext = camelContext;
        this.type = type;
        this.method = method;
        this.parameters = parameters;
        this.bodyParameters = bodyParameters;
        this.hasCustomAnnotation = hasCustomAnnotation;
        this.hasHandlerAnnotation = hasHandlerAnnotation;
        this.parametersExpression = this.createParametersExpression();
        Map<Class<?>, Annotation> collectedMethodAnnotation = this.collectMethodAnnotations(type, method);
        ExchangePattern aep = this.findExchangePatternAnnotation(collectedMethodAnnotation);
        if (aep != null) {
            this.pattern = aep;
        }
        if ((routingSlipAnnotation = (RoutingSlip)collectedMethodAnnotation.get(RoutingSlip.class)) != null) {
            this.routingSlip = PluginHelper.getAnnotationBasedProcessorFactory((CamelContext)camelContext).createRoutingSlip(camelContext, routingSlipAnnotation);
            try {
                camelContext.addService((Object)this.routingSlip);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if ((dynamicRouterAnnotation = (DynamicRouter)collectedMethodAnnotation.get(DynamicRouter.class)) != null) {
            this.dynamicRouter = PluginHelper.getAnnotationBasedProcessorFactory((CamelContext)camelContext).createDynamicRouter(camelContext, dynamicRouterAnnotation);
            try {
                camelContext.addService((Object)this.dynamicRouter);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if ((recipientListAnnotation = (RecipientList)collectedMethodAnnotation.get(RecipientList.class)) != null) {
            this.recipientList = PluginHelper.getAnnotationBasedProcessorFactory((CamelContext)camelContext).createRecipientList(camelContext, recipientListAnnotation);
            try {
                camelContext.addService((Object)this.recipientList);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    private Map<Class<?>, Annotation> collectMethodAnnotations(Class<?> c, Method method) {
        HashMap annotations = new HashMap();
        LinkedHashSet search = new LinkedHashSet();
        MethodInfo.addTypeAndSuperTypes(c, search);
        LinkedHashSet searchInterfaces = new LinkedHashSet();
        for (Class clazz : search) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                MethodInfo.addTypeAndSuperTypes(anInterface, searchInterfaces);
            }
        }
        search.addAll(searchInterfaces);
        this.collectMethodAnnotations(search.iterator(), method.getName(), annotations);
        return annotations;
    }

    private static void addTypeAndSuperTypes(Class<?> type, Set<Class<?>> result) {
        for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
            result.add(t);
        }
    }

    private void collectMethodAnnotations(Iterator<?> it, String targetMethodName, Map<Class<?>, Annotation> annotations) {
        Object[] paramTypes = this.method.getParameterTypes();
        boolean aep = false;
        while (it.hasNext()) {
            Class searchType = (Class)it.next();
            Method[] methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods();
            for (Method method : methods) {
                if (!targetMethodName.equals(method.getName()) || !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                for (Annotation a : method.getAnnotations()) {
                    Class<? extends Annotation> at = a.annotationType();
                    annotations.putIfAbsent(at, a);
                    aep |= at == Pattern.class || at == InOnly.class || at == InOut.class;
                }
            }
            if (aep) continue;
            for (Annotation a : searchType.getAnnotations()) {
                boolean valid;
                Class<? extends Annotation> at = a.annotationType();
                boolean bl = valid = at == Pattern.class || at == InOnly.class || at == InOut.class;
                if (!valid || annotations.containsKey(at)) continue;
                aep = true;
                annotations.put(at, a);
            }
        }
    }

    public String toString() {
        return this.method.toString();
    }

    public void setErrorHandler(Processor errorHandler) {
        if (this.recipientList instanceof ErrorHandlerAware) {
            ((ErrorHandlerAware)this.recipientList).setErrorHandler(errorHandler);
        }
    }

    private Object[] initializeArguments(boolean hasParameters, Exchange exchange) {
        if (hasParameters && this.parametersExpression != null) {
            this.parametersExpression.init(this.camelContext);
            return (Object[])this.parametersExpression.evaluate(exchange, Object[].class);
        }
        return null;
    }

    public MethodInvocation createMethodInvocation(final Object pojo, boolean hasParameters, final Exchange exchange) {
        final Object[] arguments = this.initializeArguments(hasParameters, exchange);
        return new MethodInvocation(){

            @Override
            public Method getMethod() {
                return MethodInfo.this.method;
            }

            @Override
            public Object[] getArguments() {
                return arguments;
            }

            @Override
            public boolean proceed(AsyncCallback callback) {
                try {
                    MessageHelper.resetStreamCache((Message)exchange.getIn());
                    return this.doProceed(callback);
                }
                catch (InvocationTargetException e) {
                    exchange.setException(e.getTargetException());
                    callback.done(true);
                    return true;
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                    callback.done(true);
                    return true;
                }
            }

            private boolean doProceed(AsyncCallback callback) throws Exception {
                Class<Void> result;
                if (MethodInfo.this.dynamicRouter != null) {
                    return this.dynamicRouterInvocation(callback);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(">>>> invoking: {} on bean: {} with arguments: {} for exchange: {}", new Object[]{MethodInfo.this.method, pojo, org.apache.camel.util.ObjectHelper.asString((Object[])arguments), exchange});
                }
                if ((result = MethodInfo.this.invoke(MethodInfo.this.method, pojo, arguments, exchange)) instanceof Callable) {
                    LOG.trace("Method returned Callback which will be called: {}", (Object)result);
                    Object callableResult = ((Callable)((Object)result)).call();
                    result = callableResult != null ? callableResult : Void.TYPE;
                }
                if (MethodInfo.this.recipientList != null) {
                    return this.recipientListInvocation(callback, result);
                }
                if (MethodInfo.this.routingSlip != null) {
                    return this.routingSlipInvocation(callback, result);
                }
                if (CompletionStage.class.isAssignableFrom(MethodInfo.this.method.getReturnType())) {
                    CompletionStage completionStage = (CompletionStage)((Object)result);
                    completionStage.whenComplete((resultObject, e) -> {
                        if (e != null) {
                            exchange.setException(e);
                        } else if (resultObject != null) {
                            MethodInfo.this.fillResult(exchange, resultObject);
                        }
                        callback.done(false);
                    });
                    return false;
                }
                if (result != Void.TYPE && !MethodInfo.this.method.getReturnType().equals(Void.TYPE)) {
                    MethodInfo.this.fillResult(exchange, result);
                }
                callback.done(true);
                return true;
            }

            private boolean routingSlipInvocation(AsyncCallback callback, Object result) {
                if (!ServiceHelper.isStarted((Object)MethodInfo.this.routingSlip)) {
                    ServiceHelper.startService((Object)MethodInfo.this.routingSlip);
                }
                exchange.setProperty(ExchangePropertyKey.EVALUATE_EXPRESSION_RESULT, result);
                return MethodInfo.this.routingSlip.process(exchange, callback);
            }

            private boolean recipientListInvocation(AsyncCallback callback, Object result) {
                if (!ServiceHelper.isStarted((Object)MethodInfo.this.recipientList)) {
                    ServiceHelper.startService((Object)MethodInfo.this.recipientList);
                }
                exchange.setProperty(ExchangePropertyKey.EVALUATE_EXPRESSION_RESULT, result);
                return MethodInfo.this.recipientList.process(exchange, callback);
            }

            private boolean dynamicRouterInvocation(AsyncCallback callback) {
                if (!ServiceHelper.isStarted((Object)MethodInfo.this.dynamicRouter)) {
                    ServiceHelper.startService((Object)MethodInfo.this.dynamicRouter);
                }
                DynamicRouterExpression expression = new DynamicRouterExpression(pojo);
                expression.init(MethodInfo.this.camelContext);
                exchange.setProperty(ExchangePropertyKey.EVALUATE_EXPRESSION_RESULT, (Object)expression);
                return MethodInfo.this.dynamicRouter.process(exchange, callback);
            }

            @Override
            public Object getThis() {
                return pojo;
            }

            @Override
            public AccessibleObject getStaticPart() {
                return MethodInfo.this.method;
            }
        };
    }

    private void fillResult(Exchange exchange, Object result) {
        boolean copyNeeded;
        Message old;
        boolean out;
        LOG.trace("Setting bean invocation result : {}", result);
        boolean bl = out = exchange.hasOut() || ExchangeHelper.isOutCapable((Exchange)exchange);
        if (out) {
            old = exchange.getOut();
            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        } else {
            old = exchange.getIn();
        }
        boolean bl2 = copyNeeded = !old.getClass().equals(DefaultMessage.class);
        if (copyNeeded) {
            DefaultMessage msg = new DefaultMessage(exchange.getContext());
            msg.copyFromWithNewBody(old, result);
            ExchangeHelper.replaceMessage((Exchange)exchange, (Message)msg, (boolean)false);
        } else {
            old.setBody(result);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public Expression getParametersExpression() {
        return this.parametersExpression;
    }

    public List<ParameterInfo> getBodyParameters() {
        return this.bodyParameters;
    }

    public Class<?> getBodyParameterType() {
        if (this.bodyParameters.isEmpty()) {
            return null;
        }
        ParameterInfo parameterInfo = this.bodyParameters.get(0);
        return parameterInfo.getType();
    }

    public boolean bodyParameterMatches(Class<?> bodyType) {
        Class<?> actualType = this.getBodyParameterType();
        return actualType != null && org.apache.camel.util.ObjectHelper.isAssignableFrom(bodyType, actualType);
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public boolean hasBodyParameter() {
        return !this.bodyParameters.isEmpty();
    }

    public boolean hasCustomAnnotation() {
        return this.hasCustomAnnotation;
    }

    public boolean hasHandlerAnnotation() {
        return this.hasHandlerAnnotation;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean isReturnTypeVoid() {
        return this.method.getReturnType().getName().equals("void");
    }

    public boolean isStaticMethod() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isCovariantWith(MethodInfo method) {
        return method.getMethod().getName().equals(this.getMethod().getName()) && (method.getMethod().getReturnType().isAssignableFrom(this.getMethod().getReturnType()) || this.getMethod().getReturnType().isAssignableFrom(method.getMethod().getReturnType())) && Arrays.deepEquals(method.getMethod().getParameterTypes(), this.getMethod().getParameterTypes());
    }

    protected Object invoke(Method mth, Object pojo, Object[] arguments, Exchange exchange) throws InvocationTargetException {
        try {
            return ObjectHelper.invokeMethodSafe((Method)mth, (Object)pojo, (Object[])arguments);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExchangeException("IllegalAccessException occurred invoking method: " + mth + " using arguments: " + org.apache.camel.util.ObjectHelper.asList((Object[])arguments), exchange, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeExchangeException("IllegalArgumentException occurred invoking method: " + mth + " using arguments: " + org.apache.camel.util.ObjectHelper.asList((Object[])arguments), exchange, (Throwable)e);
        }
    }

    protected Expression[] createParameterExpressions() {
        int size = this.parameters.size();
        LOG.trace("Creating parameters expression for {} parameters", (Object)size);
        Expression[] expressions = new Expression[size];
        for (int i = 0; i < size; ++i) {
            Expression parameterExpression;
            expressions[i] = parameterExpression = this.parameters.get(i).getExpression();
            LOG.trace("Parameter #{} has expression: {}", (Object)i, (Object)parameterExpression);
        }
        return expressions;
    }

    protected Expression createParametersExpression() {
        return new ParameterExpression(this.createParameterExpressions());
    }

    protected ExchangePattern findExchangePatternAnnotation(Map<Class<?>, Annotation> collectedMethodAnnotation) {
        if (collectedMethodAnnotation.get(InOnly.class) != null) {
            return ExchangePattern.InOnly;
        }
        if (collectedMethodAnnotation.get(InOut.class) != null) {
            return ExchangePattern.InOut;
        }
        Pattern pattern = (Pattern)collectedMethodAnnotation.get(Pattern.class);
        return pattern != null ? pattern.value() : null;
    }

    protected boolean hasExceptionParameter() {
        for (ParameterInfo parameter : this.parameters) {
            if (!Exception.class.isAssignableFrom(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    private final class ParameterExpression
    implements Expression {
        private final Expression[] expressions;

        ParameterExpression(Expression[] expressions) {
            this.expressions = expressions;
        }

        public void init(CamelContext context) {
            if (this.expressions != null) {
                for (Expression exp : this.expressions) {
                    if (exp == null) continue;
                    exp.init(context);
                }
            }
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            Object body = exchange.getIn().getBody();
            String methodName = (String)exchange.getProperty("CamelBeanMethodName", String.class);
            String methodParameters = StringHelper.betweenOuterPair((String)methodName, (char)'(', (char)')');
            Iterator it = null;
            if (methodParameters != null) {
                String[] parameters = StringQuoteHelper.splitSafeQuote((String)methodParameters, (char)',', (boolean)true, (boolean)true);
                it = ObjectHelper.createIterator((Object)parameters, (String)",", (boolean)true);
            }
            if (methodName != null) {
                exchange.removeProperty("CamelBeanMethodName");
            }
            Object[] answer = this.evaluateParameterExpressions(exchange, body, it);
            return (T)answer;
        }

        private Object[] evaluateParameterExpressions(Exchange exchange, Object body, Iterator<?> it) {
            Object[] answer = new Object[this.expressions != null ? this.expressions.length : 1];
            for (int i = 0; this.expressions == null || i < this.expressions.length; ++i) {
                Expression expression;
                if (body instanceof StreamCache) {
                    ((StreamCache)body).reset();
                }
                boolean varargs = MethodInfo.this.parameters.get(i).isVarargs();
                Class<?> parameterType = MethodInfo.this.parameters.get(i).getType();
                Object value = null;
                if (varargs) {
                    value = this.evaluateVarargsParameterExpressions(exchange, body, it);
                } else {
                    Object parameterValue;
                    Object object = parameterValue = it != null && it.hasNext() ? (Object)it.next() : null;
                    if (parameterValue != null && !parameterValue.equals("*")) {
                        value = this.evaluateParameterValue(exchange, i, parameterValue, parameterType, false);
                    }
                }
                Expression expression2 = expression = this.expressions != null ? this.expressions[i] : null;
                if (value == null && expression != null) {
                    value = this.evaluateParameterBinding(exchange, expression, i, parameterType, false);
                }
                if (value == Void.TYPE) continue;
                answer[i] = value;
            }
            return answer;
        }

        private Object evaluateVarargsParameterExpressions(Exchange exchange, Object body, Iterator<?> it) {
            if (body instanceof StreamCache) {
                ((StreamCache)body).reset();
            }
            ArrayList<Object> answer = new ArrayList<Object>();
            int i = 0;
            while (it.hasNext()) {
                Object parameterValue = it.next();
                Object value = null;
                if (parameterValue != null && !parameterValue.equals("*")) {
                    value = this.evaluateParameterValue(exchange, i, parameterValue, Object.class, true);
                }
                if (value != Void.TYPE) {
                    answer.add(value);
                }
                ++i;
            }
            return answer.toArray(new Object[0]);
        }

        private Object evaluateParameterValue(Exchange exchange, int index, Object parameterValue, Class<?> parameterType, boolean varargs) {
            Object answer = null;
            String exp = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, parameterValue);
            if (exp != null) {
                Boolean isClass;
                boolean valid;
                int pos1 = exp.indexOf(32);
                int pos2 = exp.indexOf(".class");
                if (pos1 != -1 && pos2 != -1 && pos1 > pos2) {
                    exp = exp.substring(pos2 + 7);
                }
                if (!(valid = BeanHelper.isValidParameterValue(exp)) && !varargs && (isClass = BeanHelper.isAssignableToExpectedType(exchange.getContext().getClassResolver(), exp, parameterType)) != null) {
                    return null;
                }
                Expression expression = null;
                try {
                    expression = exchange.getContext().resolveLanguage("simple").createExpression(exp);
                    parameterValue = expression.evaluate(exchange, Object.class);
                    if (parameterValue == null) {
                        parameterValue = "null";
                    }
                }
                catch (Exception e) {
                    throw new ExpressionEvaluationException(expression, "Cannot create/evaluate simple expression: " + exp + " to be bound to parameter at index: " + index + " on method: " + MethodInfo.this.getMethod(), exchange, (Throwable)e);
                }
                if ("null".equals(parameterValue)) {
                    return Void.TYPE;
                }
                if (varargs || parameterType.isAssignableFrom(parameterValue.getClass())) {
                    valid = true;
                } else if (!valid && !(valid = parameterValue instanceof String)) {
                    exp = (String)exchange.getContext().getTypeConverter().tryConvertTo(String.class, parameterValue);
                    valid = BeanHelper.isValidParameterValue(exp);
                }
                if (valid) {
                    if (parameterValue instanceof String) {
                        parameterValue = StringHelper.removeLeadingAndEndingQuotes((String)((String)parameterValue));
                    }
                    if (varargs) {
                        answer = parameterValue;
                    } else {
                        try {
                            answer = exchange.getContext().getTypeConverter().mandatoryConvertTo(parameterType, exchange, parameterValue);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Parameter #{} evaluated as: {} type: {}", new Object[]{index, answer, org.apache.camel.util.ObjectHelper.type((Object)answer)});
                            }
                        }
                        catch (Exception e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Cannot convert from type: {} to type: {} for parameter #{}", new Object[]{org.apache.camel.util.ObjectHelper.type((Object)parameterValue), parameterType, index});
                            }
                            throw new ParameterBindingException(e, MethodInfo.this.method, index, parameterType, parameterValue);
                        }
                    }
                }
            }
            return answer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object evaluateParameterBinding(Exchange exchange, Expression expression, int index, Class<?> parameterType, boolean varargs) {
            Object answer = null;
            Object result = expression.evaluate(exchange, Object.class);
            if (result != null) {
                if (varargs) {
                    return result;
                }
                try {
                    answer = parameterType.isInstance(result) ? result : exchange.getContext().getTypeConverter().mandatoryConvertTo(parameterType, result);
                    if (!LOG.isTraceEnabled()) return answer;
                    LOG.trace("Parameter #{} evaluated as: {} type: {}", new Object[]{index, answer, org.apache.camel.util.ObjectHelper.type((Object)answer)});
                    return answer;
                }
                catch (NoTypeConversionAvailableException e) {
                    if (!LOG.isDebugEnabled()) throw new ParameterBindingException(e, MethodInfo.this.method, index, parameterType, result);
                    LOG.debug("Cannot convert from type: {} to type: {} for parameter #{}", new Object[]{org.apache.camel.util.ObjectHelper.type((Object)result), parameterType, index});
                    throw new ParameterBindingException(e, MethodInfo.this.method, index, parameterType, result);
                }
            } else {
                LOG.trace("Parameter #{} evaluated as null", (Object)index);
            }
            return answer;
        }

        public String toString() {
            return "ParametersExpression: " + Arrays.asList(this.expressions);
        }
    }

    private final class DynamicRouterExpression
    extends ExpressionAdapter {
        private final Object pojo;

        private DynamicRouterExpression(Object pojo) {
            this.pojo = pojo;
        }

        public Object evaluate(Exchange exchange) {
            Object[] arguments = (Object[])MethodInfo.this.parametersExpression.evaluate(exchange, Object[].class);
            try {
                return MethodInfo.this.invoke(MethodInfo.this.method, this.pojo, arguments, exchange);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }

        public String toString() {
            return "DynamicRouter[invoking: " + MethodInfo.this.method + " on bean: " + this.pojo + "]";
        }
    }
}

