/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.TypeConverterSupport;

public class StaticMethodTypeConverter
extends TypeConverterSupport {
    private final Method method;
    private final boolean useExchange;
    private final boolean allowNull;

    public StaticMethodTypeConverter(Method method, boolean allowNull) {
        this.method = method;
        this.useExchange = method.getParameterCount() == 2;
        this.allowNull = allowNull;
    }

    public String toString() {
        return "StaticMethodTypeConverter: " + this.method;
    }

    public boolean allowNull() {
        return this.allowNull;
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        Class<Void> answer;
        Class<Void> clazz = answer = this.useExchange ? ObjectHelper.invokeMethod((Method)this.method, null, (Object[])new Object[]{value, exchange}) : ObjectHelper.invokeMethod((Method)this.method, null, (Object[])new Object[]{value});
        if (answer == null && this.allowNull) {
            answer = Void.class;
        }
        return (T)answer;
    }
}

