/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.examples;

import org.apache.avro.Schema;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import za.co.absa.abris.avro.format.SparkAvroConversions$;
import za.co.absa.abris.avro.functions$;
import za.co.absa.abris.avro.parsing.utils.AvroSchemaUtils$;
import za.co.absa.abris.config.AbrisConfig$;
import za.co.absa.abris.config.ToAvroConfig;
import za.co.absa.abris.config.ToConfluentAvroRegistrationStrategyConfigFragment;
import za.co.absa.abris.examples.data.generation.ComplexRecordsGenerator$;

public final class ConfluentKafkaAvroWriter$ {
    public static final ConfluentKafkaAvroWriter$ MODULE$;
    private final String kafkaTopicName;
    private final int dummyDataRows;
    private final int dummyDataPartitions;

    static {
        new ConfluentKafkaAvroWriter$();
    }

    public String kafkaTopicName() {
        return this.kafkaTopicName;
    }

    public int dummyDataRows() {
        return this.dummyDataRows;
    }

    public int dummyDataPartitions() {
        return this.dummyDataPartitions;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("ReaderJob").master("local[2]").getOrCreate();
        spark.sparkContext().setLogLevel("INFO");
        Dataset<Row> dataFrame = this.generateRandomDataFrame(spark);
        dataFrame.show(false);
        String schemaString = ComplexRecordsGenerator$.MODULE$.usedAvroSchema();
        Column allColumns = org.apache.spark.sql.functions$.MODULE$.struct((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dataFrame.columns()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return org.apache.spark.sql.functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))).toIndexedSeq());
        ToConfluentAvroRegistrationStrategyConfigFragment qual$1 = AbrisConfig$.MODULE$.toConfluentAvro().provideAndRegisterSchema(schemaString);
        String x$1 = this.kafkaTopicName();
        boolean x$2 = qual$1.usingTopicNameStrategy$default$2();
        ToAvroConfig abrisConfig = qual$1.usingTopicNameStrategy(x$1, x$2).usingSchemaRegistry("http://localhost:8081");
        Dataset avroFrame = dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_avro(allColumns, abrisConfig).as("value")}));
        avroFrame.write().format("kafka").option("kafka.bootstrap.servers", "localhost:9092").option("topic", this.kafkaTopicName()).save();
    }

    private Dataset<Row> generateRandomDataFrame(SparkSession spark) {
        Encoder<Row> encoder = this.getEncoder();
        List<Row> rows = this.createRows(this.dummyDataRows());
        return spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize(rows, this.dummyDataPartitions(), ClassTag$.MODULE$.apply(Row.class)), encoder).toDF();
    }

    private List<Row> createRows(int howMany) {
        return ComplexRecordsGenerator$.MODULE$.generateUnparsedRows(howMany);
    }

    private Encoder<Row> getEncoder() {
        Schema avroSchema = AvroSchemaUtils$.MODULE$.parse(ComplexRecordsGenerator$.MODULE$.usedAvroSchema());
        StructType sparkSchema = SparkAvroConversions$.MODULE$.toSqlType(avroSchema);
        return RowEncoder$.MODULE$.apply(sparkSchema);
    }

    private ConfluentKafkaAvroWriter$() {
        MODULE$ = this;
        this.kafkaTopicName = "test_topic";
        this.dummyDataRows = 5;
        this.dummyDataPartitions = 1;
    }
}

