/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.parsing.utils;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;

public final class AvroSchemaUtils$ {
    public static final AvroSchemaUtils$ MODULE$;

    static {
        new AvroSchemaUtils$();
    }

    public Schema parse(String schema) {
        return new Schema.Parser().parse(schema);
    }

    public Schema load(String path) {
        return this.parse(this.loadPlain(path));
    }

    /*
     * WARNING - void declaration
     */
    public String loadPlain(String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Null path informed. Please make sure you provide a valid path to an existing Avro schema located in some file system.");
        }
        FileSystem hdfs = FileSystem.get((Configuration)new Configuration());
        FSDataInputStream stream = hdfs.open(new Path(path));
        try {
            string = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((InputStream)stream, (Charset)Charset.defaultCharset())).asScala()).mkString("\n");
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        stream.close();
        return string;
    }

    public Schema toAvroSchema(Dataset<Row> dataFrame, String columnName, String recordName, String nameSpace) {
        int fieldIndex = dataFrame.schema().fieldIndex(columnName);
        StructField field = dataFrame.schema().fields()[fieldIndex];
        return SchemaConverters$.MODULE$.toAvroType(field.dataType(), field.nullable(), recordName, nameSpace);
    }

    public Schema toAvroSchema(Dataset<Row> dataFrame, Seq<String> columnNames) {
        return this.toAvroSchema(dataFrame, columnNames, "topLevelRecord", "");
    }

    public Schema toAvroSchema(Dataset<Row> dataFrame, Seq<String> columnNames, String recordName, String nameSpace) {
        Column allColumns = functions$.MODULE$.struct((Seq)columnNames.map((Function1)new Serializable(dataFrame){
            public static final long serialVersionUID = 0L;
            private final Dataset dataFrame$1;

            public final Column apply(String colName) {
                return this.dataFrame$1.col(colName);
            }
            {
                this.dataFrame$1 = dataFrame$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Expression expression = allColumns.expr();
        return SchemaConverters$.MODULE$.toAvroType(expression.dataType(), expression.nullable(), recordName, nameSpace);
    }

    public Schema toAvroSchema(Dataset<Row> dataFrame) {
        return this.toAvroSchema(dataFrame, "topLevelRecord", "");
    }

    public Schema toAvroSchema(Dataset<Row> dataFrame, String recordName, String nameSpace) {
        return this.toAvroSchema(dataFrame, (Seq<String>)Predef$.MODULE$.refArrayOps((Object[])dataFrame.columns()).toIndexedSeq(), recordName, nameSpace);
    }

    public String toAvroSchema$default$3() {
        return "topLevelRecord";
    }

    public String toAvroSchema$default$4() {
        return "";
    }

    public Schema wrapSchema(Schema schema, String name, String namespace) {
        return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)name).namespace(namespace)).fields().name(schema.getName()).type(schema).noDefault().endRecord();
    }

    private AvroSchemaUtils$() {
        MODULE$ = this;
    }
}

