/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands.scan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import xyz.capybara.clamav.InvalidResponseException;
import xyz.capybara.clamav.ScanFailureException;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.scan.result.ScanResult;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b \u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\b"}, d2={"Lxyz/capybara/clamav/commands/scan/ScanCommand;", "Lxyz/capybara/clamav/commands/Command;", "Lxyz/capybara/clamav/commands/scan/result/ScanResult;", "()V", "parseResponse", "responseString", "", "Companion", "clamav-client"})
public abstract class ScanCommand
extends Command<ScanResult> {
    private static final Regex RESPONSE_OK;
    private static final Regex RESPONSE_VIRUS_FOUND;
    private static final Regex RESPONSE_ERROR;
    private static final Regex RESPONSE_VIRUS_FOUND_LINE;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ScanResult parseResponse(@NotNull String responseString) {
        Intrinsics.checkParameterIsNotNull((Object)responseString, (String)"responseString");
        try {
            ScanResult scanResult;
            if (ScanCommand.Companion.getRESPONSE_OK().matches((CharSequence)responseString)) {
                scanResult = ScanResult.OK.INSTANCE;
            } else if (ScanCommand.Companion.getRESPONSE_VIRUS_FOUND().containsMatchIn((CharSequence)responseString)) {
                Object object;
                List it;
                Collection collection;
                Iterable $receiver$iv$iv;
                void $receiver$iv$iv2;
                Iterable $receiver$iv;
                Object object2 = responseString;
                Object object3 = "\n";
                object3 = new Regex((String)object3);
                int n = 0;
                object2 = object3.split((CharSequence)object2, n);
                object3 = ScanCommand.Companion.getRESPONSE_VIRUS_FOUND_LINE();
                void var5_5 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv2;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    MatchResult matchResult;
                    Object element$iv$iv = element$iv$iv$iv;
                    CharSequence p1 = (CharSequence)element$iv$iv;
                    if (object3.matchEntire(p1) == null) continue;
                    MatchResult it$iv$iv = matchResult;
                    destination$iv$iv.add(it$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                object3 = $receiver$iv;
                Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    MatchResult matchResult = (MatchResult)item$iv$iv;
                    collection = destination$iv$iv2;
                    object = CollectionsKt.reversed((Iterable)((Iterable)it.getGroups()));
                    collection.add(object);
                }
                $receiver$iv = (List)destination$iv$iv2;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv2 = new LinkedHashMap();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    Object object4;
                    String key$iv$iv;
                    Object $receiver$iv$iv$iv2;
                    Object value$iv$iv$iv;
                    it = (List)element$iv$iv;
                    Object e = it.get(1);
                    if (e == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((value$iv$iv$iv = ($receiver$iv$iv$iv2 = destination$iv$iv2).get(key$iv$iv = ((MatchGroup)e).getValue())) == null) {
                        ArrayList answer$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                        object4 = answer$iv$iv$iv;
                    } else {
                        object4 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object4;
                    it = (List)element$iv$iv;
                    collection = list$iv$iv;
                    Object e2 = it.get(0);
                    if (e2 == null) {
                        Intrinsics.throwNpe();
                    }
                    object = ((MatchGroup)e2).getValue();
                    collection.add(object);
                }
                Object foundViruses = destination$iv$iv2;
                scanResult = new ScanResult.VirusFound((Map<String, ? extends Collection<String>>)foundViruses);
            } else {
                if (ScanCommand.Companion.getRESPONSE_ERROR().matches((CharSequence)responseString)) {
                    throw (Throwable)new ScanFailureException(responseString);
                }
                throw (Throwable)new InvalidResponseException(responseString);
            }
            return scanResult;
        }
        catch (IllegalStateException e) {
            throw (Throwable)new InvalidResponseException(responseString);
        }
    }

    static {
        Companion = new Companion(null);
        RESPONSE_OK = new Regex("(.+) OK$", RegexOption.UNIX_LINES);
        RESPONSE_VIRUS_FOUND = new Regex("(.+) FOUND$", SetsKt.setOf((Object[])new RegexOption[]{RegexOption.MULTILINE, RegexOption.UNIX_LINES}));
        RESPONSE_ERROR = new Regex("(.+) ERROR", RegexOption.UNIX_LINES);
        RESPONSE_VIRUS_FOUND_LINE = new Regex("(.+: )?(.+): (.+) FOUND$", RegexOption.UNIX_LINES);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lxyz/capybara/clamav/commands/scan/ScanCommand$Companion;", "", "()V", "RESPONSE_ERROR", "Lkotlin/text/Regex;", "getRESPONSE_ERROR", "()Lkotlin/text/Regex;", "RESPONSE_OK", "getRESPONSE_OK", "RESPONSE_VIRUS_FOUND", "getRESPONSE_VIRUS_FOUND", "RESPONSE_VIRUS_FOUND_LINE", "getRESPONSE_VIRUS_FOUND_LINE", "clamav-client"})
    public static final class Companion {
        private final Regex getRESPONSE_OK() {
            return RESPONSE_OK;
        }

        private final Regex getRESPONSE_VIRUS_FOUND() {
            return RESPONSE_VIRUS_FOUND;
        }

        private final Regex getRESPONSE_ERROR() {
            return RESPONSE_ERROR;
        }

        private final Regex getRESPONSE_VIRUS_FOUND_LINE() {
            return RESPONSE_VIRUS_FOUND_LINE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

