/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentBookmark;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentInfo;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentPermission;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.mark.XEasyPdfWatermark;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

class XEasyPdfDocumentParam
implements Serializable {
    private static final long serialVersionUID = 2578484264342461916L;
    private static final String PRODUCER = "x-easypdf/pdfbox";
    private XEasyPdfComponent.ContentMode contentMode = XEasyPdfComponent.ContentMode.APPEND;
    private Boolean isResetContext = Boolean.FALSE;
    private Boolean isReplaceTotalPagePlaceholder = Boolean.FALSE;
    private XEasyPdfDefaultFontStyle defaultFontStyle = XEasyPdfDefaultFontStyle.NORMAL;
    private String fontPath;
    private PDFont font;
    private final Map<String, PDFont> fontCache = new ConcurrentHashMap<String, PDFont>(8);
    private final Map<String, PDFont> otfFontCache = new ConcurrentHashMap<String, PDFont>(8);
    private PDDocument source;
    private PDDocument target;
    private List<String> tempTargetList = new ArrayList<String>(16);
    private String tempDir;
    private Float version = Float.valueOf(1.5f);
    private Integer totalPage = 0;
    private List<XEasyPdfDocument> mergeSourceList = new ArrayList<XEasyPdfDocument>(10);
    private List<XEasyPdfPage> pageList = new ArrayList<XEasyPdfPage>(32);
    private Float globalMarginLeft;
    private Float globalMarginRight;
    private Float globalMarginTop;
    private Float globalMarginBottom;
    private Color globalBackgroundColor = Color.WHITE;
    private XEasyPdfImage globalBackgroundImage;
    private XEasyPdfWatermark globalWatermark;
    private XEasyPdfHeader globalHeader;
    private XEasyPdfFooter globalFooter;
    private XEasyPdfDocumentPermission permission;
    private XEasyPdfDocumentInfo documentInfo;
    private XEasyPdfDocumentBookmark bookmark;
    private Boolean isReset = Boolean.FALSE;

    String getTempUrl() {
        return (this.tempDir != null ? this.tempDir : "") + File.separatorChar + this.tempTargetList.size();
    }

    void init(InputStream inputStream, String password, XEasyPdfDocument document) {
        this.init(inputStream, password, null, null, document);
    }

    void init(InputStream inputStream, String password, InputStream keyStore, String alias, XEasyPdfDocument document) {
        this.source = PDDocument.load((InputStream)inputStream, (String)password, (InputStream)keyStore, (String)alias, (MemoryUsageSetting)MemoryUsageSetting.setupMainMemoryOnly());
        PDPageTree pages = this.source.getPages();
        for (PDPage page : pages) {
            this.pageList.add(new XEasyPdfPage(page));
        }
        this.initTotalPage(pages.getCount());
        this.initInfo(document);
    }

    void initTarget(XEasyPdfDocument document) {
        if (this.target != null) {
            this.target.close();
        }
        this.target = new PDDocument();
        if (this.source != null) {
            PDDocumentCatalog documentCatalog = this.target.getDocumentCatalog();
            documentCatalog.setAcroForm(this.source.getDocumentCatalog().getAcroForm());
            documentCatalog.setDocumentOutline(this.source.getDocumentCatalog().getDocumentOutline());
        }
        this.isReset = Boolean.FALSE;
        this.initFont(document);
    }

    void initPage(XEasyPdfDocument document) {
        for (XEasyPdfPage pdfPage : this.pageList) {
            pdfPage.build(document);
            List<PDPage> pdfboxPageList = pdfPage.getPageList();
            for (PDPage page : pdfboxPageList) {
                PDPage importPage = this.target.importPage(page);
                importPage.setResources(page.getResources());
            }
            PDPageTree pageTree = this.target.getPages();
            pdfboxPageList = pdfPage.getNewPageList();
            for (PDPage page : pdfboxPageList) {
                pageTree.add(page);
            }
        }
        this.embedFont(this.fontCache.values());
    }

    void embedFont(Collection<PDFont> fonts) {
        if (fonts != null && !fonts.isEmpty()) {
            Method method = this.target.getClass().getDeclaredMethod("getFontsToSubset", new Class[0]);
            method.setAccessible(true);
            ((Set)method.invoke((Object)this.target, new Object[0])).addAll(fonts);
        }
    }

    void initTotalPage(int count) {
        XEasyPdfDocumentParam xEasyPdfDocumentParam = this;
        xEasyPdfDocumentParam.totalPage = xEasyPdfDocumentParam.totalPage + count;
    }

    String getProducer() {
        return PRODUCER;
    }

    private void initFont(XEasyPdfDocument document) {
        this.fontCache.clear();
        this.otfFontCache.clear();
        if (this.fontPath == null) {
            this.fontPath = this.defaultFontStyle.getPath();
        }
        this.font = XEasyPdfFontUtil.loadFont(document, this.fontPath, true);
    }

    private void initInfo(XEasyPdfDocument document) {
        PDDocumentInformation documentInformation = this.source.getDocumentInformation();
        this.documentInfo = new XEasyPdfDocumentInfo(document).setTitle(documentInformation.getTitle()).setAuthor(documentInformation.getAuthor()).setSubject(documentInformation.getSubject()).setKeywords(documentInformation.getKeywords()).setCreator(documentInformation.getCreator()).setCreateTime(documentInformation.getCreationDate()).setUpdateTime(documentInformation.getModificationDate());
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public Boolean getIsReplaceTotalPagePlaceholder() {
        return this.isReplaceTotalPagePlaceholder;
    }

    public XEasyPdfDefaultFontStyle getDefaultFontStyle() {
        return this.defaultFontStyle;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Map<String, PDFont> getFontCache() {
        return this.fontCache;
    }

    public Map<String, PDFont> getOtfFontCache() {
        return this.otfFontCache;
    }

    public PDDocument getSource() {
        return this.source;
    }

    public PDDocument getTarget() {
        return this.target;
    }

    public List<String> getTempTargetList() {
        return this.tempTargetList;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public Float getVersion() {
        return this.version;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public List<XEasyPdfDocument> getMergeSourceList() {
        return this.mergeSourceList;
    }

    public List<XEasyPdfPage> getPageList() {
        return this.pageList;
    }

    public Float getGlobalMarginLeft() {
        return this.globalMarginLeft;
    }

    public Float getGlobalMarginRight() {
        return this.globalMarginRight;
    }

    public Float getGlobalMarginTop() {
        return this.globalMarginTop;
    }

    public Float getGlobalMarginBottom() {
        return this.globalMarginBottom;
    }

    public Color getGlobalBackgroundColor() {
        return this.globalBackgroundColor;
    }

    public XEasyPdfImage getGlobalBackgroundImage() {
        return this.globalBackgroundImage;
    }

    public XEasyPdfWatermark getGlobalWatermark() {
        return this.globalWatermark;
    }

    public XEasyPdfHeader getGlobalHeader() {
        return this.globalHeader;
    }

    public XEasyPdfFooter getGlobalFooter() {
        return this.globalFooter;
    }

    public XEasyPdfDocumentPermission getPermission() {
        return this.permission;
    }

    public XEasyPdfDocumentInfo getDocumentInfo() {
        return this.documentInfo;
    }

    public XEasyPdfDocumentBookmark getBookmark() {
        return this.bookmark;
    }

    public Boolean getIsReset() {
        return this.isReset;
    }

    public XEasyPdfDocumentParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfDocumentParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfDocumentParam setIsReplaceTotalPagePlaceholder(Boolean isReplaceTotalPagePlaceholder) {
        this.isReplaceTotalPagePlaceholder = isReplaceTotalPagePlaceholder;
        return this;
    }

    public XEasyPdfDocumentParam setDefaultFontStyle(XEasyPdfDefaultFontStyle defaultFontStyle) {
        this.defaultFontStyle = defaultFontStyle;
        return this;
    }

    public XEasyPdfDocumentParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfDocumentParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfDocumentParam setSource(PDDocument source) {
        this.source = source;
        return this;
    }

    public XEasyPdfDocumentParam setTarget(PDDocument target) {
        this.target = target;
        return this;
    }

    public XEasyPdfDocumentParam setTempTargetList(List<String> tempTargetList) {
        this.tempTargetList = tempTargetList;
        return this;
    }

    public XEasyPdfDocumentParam setTempDir(String tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    public XEasyPdfDocumentParam setVersion(Float version) {
        this.version = version;
        return this;
    }

    public XEasyPdfDocumentParam setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
        return this;
    }

    public XEasyPdfDocumentParam setMergeSourceList(List<XEasyPdfDocument> mergeSourceList) {
        this.mergeSourceList = mergeSourceList;
        return this;
    }

    public XEasyPdfDocumentParam setPageList(List<XEasyPdfPage> pageList) {
        this.pageList = pageList;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalMarginLeft(Float globalMarginLeft) {
        this.globalMarginLeft = globalMarginLeft;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalMarginRight(Float globalMarginRight) {
        this.globalMarginRight = globalMarginRight;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalMarginTop(Float globalMarginTop) {
        this.globalMarginTop = globalMarginTop;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalMarginBottom(Float globalMarginBottom) {
        this.globalMarginBottom = globalMarginBottom;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalBackgroundColor(Color globalBackgroundColor) {
        this.globalBackgroundColor = globalBackgroundColor;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalBackgroundImage(XEasyPdfImage globalBackgroundImage) {
        this.globalBackgroundImage = globalBackgroundImage;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalWatermark(XEasyPdfWatermark globalWatermark) {
        this.globalWatermark = globalWatermark;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalHeader(XEasyPdfHeader globalHeader) {
        this.globalHeader = globalHeader;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalFooter(XEasyPdfFooter globalFooter) {
        this.globalFooter = globalFooter;
        return this;
    }

    public XEasyPdfDocumentParam setPermission(XEasyPdfDocumentPermission permission) {
        this.permission = permission;
        return this;
    }

    public XEasyPdfDocumentParam setDocumentInfo(XEasyPdfDocumentInfo documentInfo) {
        this.documentInfo = documentInfo;
        return this;
    }

    public XEasyPdfDocumentParam setBookmark(XEasyPdfDocumentBookmark bookmark) {
        this.bookmark = bookmark;
        return this;
    }

    public XEasyPdfDocumentParam setIsReset(Boolean isReset) {
        this.isReset = isReset;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfDocumentParam)) {
            return false;
        }
        XEasyPdfDocumentParam other = (XEasyPdfDocumentParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Boolean this$isReplaceTotalPagePlaceholder = this.getIsReplaceTotalPagePlaceholder();
        Boolean other$isReplaceTotalPagePlaceholder = other.getIsReplaceTotalPagePlaceholder();
        if (this$isReplaceTotalPagePlaceholder == null ? other$isReplaceTotalPagePlaceholder != null : !((Object)this$isReplaceTotalPagePlaceholder).equals(other$isReplaceTotalPagePlaceholder)) {
            return false;
        }
        Float this$version = this.getVersion();
        Float other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Integer this$totalPage = this.getTotalPage();
        Integer other$totalPage = other.getTotalPage();
        if (this$totalPage == null ? other$totalPage != null : !((Object)this$totalPage).equals(other$totalPage)) {
            return false;
        }
        Float this$globalMarginLeft = this.getGlobalMarginLeft();
        Float other$globalMarginLeft = other.getGlobalMarginLeft();
        if (this$globalMarginLeft == null ? other$globalMarginLeft != null : !((Object)this$globalMarginLeft).equals(other$globalMarginLeft)) {
            return false;
        }
        Float this$globalMarginRight = this.getGlobalMarginRight();
        Float other$globalMarginRight = other.getGlobalMarginRight();
        if (this$globalMarginRight == null ? other$globalMarginRight != null : !((Object)this$globalMarginRight).equals(other$globalMarginRight)) {
            return false;
        }
        Float this$globalMarginTop = this.getGlobalMarginTop();
        Float other$globalMarginTop = other.getGlobalMarginTop();
        if (this$globalMarginTop == null ? other$globalMarginTop != null : !((Object)this$globalMarginTop).equals(other$globalMarginTop)) {
            return false;
        }
        Float this$globalMarginBottom = this.getGlobalMarginBottom();
        Float other$globalMarginBottom = other.getGlobalMarginBottom();
        if (this$globalMarginBottom == null ? other$globalMarginBottom != null : !((Object)this$globalMarginBottom).equals(other$globalMarginBottom)) {
            return false;
        }
        Boolean this$isReset = this.getIsReset();
        Boolean other$isReset = other.getIsReset();
        if (this$isReset == null ? other$isReset != null : !((Object)this$isReset).equals(other$isReset)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        XEasyPdfDefaultFontStyle this$defaultFontStyle = this.getDefaultFontStyle();
        XEasyPdfDefaultFontStyle other$defaultFontStyle = other.getDefaultFontStyle();
        if (this$defaultFontStyle == null ? other$defaultFontStyle != null : !((Object)((Object)this$defaultFontStyle)).equals((Object)other$defaultFontStyle)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Map<String, PDFont> this$fontCache = this.getFontCache();
        Map<String, PDFont> other$fontCache = other.getFontCache();
        if (this$fontCache == null ? other$fontCache != null : !((Object)this$fontCache).equals(other$fontCache)) {
            return false;
        }
        Map<String, PDFont> this$otfFontCache = this.getOtfFontCache();
        Map<String, PDFont> other$otfFontCache = other.getOtfFontCache();
        if (this$otfFontCache == null ? other$otfFontCache != null : !((Object)this$otfFontCache).equals(other$otfFontCache)) {
            return false;
        }
        PDDocument this$source = this.getSource();
        PDDocument other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        PDDocument this$target = this.getTarget();
        PDDocument other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        List<String> this$tempTargetList = this.getTempTargetList();
        List<String> other$tempTargetList = other.getTempTargetList();
        if (this$tempTargetList == null ? other$tempTargetList != null : !((Object)this$tempTargetList).equals(other$tempTargetList)) {
            return false;
        }
        String this$tempDir = this.getTempDir();
        String other$tempDir = other.getTempDir();
        if (this$tempDir == null ? other$tempDir != null : !this$tempDir.equals(other$tempDir)) {
            return false;
        }
        List<XEasyPdfDocument> this$mergeSourceList = this.getMergeSourceList();
        List<XEasyPdfDocument> other$mergeSourceList = other.getMergeSourceList();
        if (this$mergeSourceList == null ? other$mergeSourceList != null : !((Object)this$mergeSourceList).equals(other$mergeSourceList)) {
            return false;
        }
        List<XEasyPdfPage> this$pageList = this.getPageList();
        List<XEasyPdfPage> other$pageList = other.getPageList();
        if (this$pageList == null ? other$pageList != null : !((Object)this$pageList).equals(other$pageList)) {
            return false;
        }
        Color this$globalBackgroundColor = this.getGlobalBackgroundColor();
        Color other$globalBackgroundColor = other.getGlobalBackgroundColor();
        if (this$globalBackgroundColor == null ? other$globalBackgroundColor != null : !((Object)this$globalBackgroundColor).equals(other$globalBackgroundColor)) {
            return false;
        }
        XEasyPdfImage this$globalBackgroundImage = this.getGlobalBackgroundImage();
        XEasyPdfImage other$globalBackgroundImage = other.getGlobalBackgroundImage();
        if (this$globalBackgroundImage == null ? other$globalBackgroundImage != null : !((Object)this$globalBackgroundImage).equals(other$globalBackgroundImage)) {
            return false;
        }
        XEasyPdfWatermark this$globalWatermark = this.getGlobalWatermark();
        XEasyPdfWatermark other$globalWatermark = other.getGlobalWatermark();
        if (this$globalWatermark == null ? other$globalWatermark != null : !this$globalWatermark.equals(other$globalWatermark)) {
            return false;
        }
        XEasyPdfHeader this$globalHeader = this.getGlobalHeader();
        XEasyPdfHeader other$globalHeader = other.getGlobalHeader();
        if (this$globalHeader == null ? other$globalHeader != null : !this$globalHeader.equals(other$globalHeader)) {
            return false;
        }
        XEasyPdfFooter this$globalFooter = this.getGlobalFooter();
        XEasyPdfFooter other$globalFooter = other.getGlobalFooter();
        if (this$globalFooter == null ? other$globalFooter != null : !this$globalFooter.equals(other$globalFooter)) {
            return false;
        }
        XEasyPdfDocumentPermission this$permission = this.getPermission();
        XEasyPdfDocumentPermission other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) {
            return false;
        }
        XEasyPdfDocumentInfo this$documentInfo = this.getDocumentInfo();
        XEasyPdfDocumentInfo other$documentInfo = other.getDocumentInfo();
        if (this$documentInfo == null ? other$documentInfo != null : !this$documentInfo.equals(other$documentInfo)) {
            return false;
        }
        XEasyPdfDocumentBookmark this$bookmark = this.getBookmark();
        XEasyPdfDocumentBookmark other$bookmark = other.getBookmark();
        return !(this$bookmark == null ? other$bookmark != null : !this$bookmark.equals(other$bookmark));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfDocumentParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Boolean $isReplaceTotalPagePlaceholder = this.getIsReplaceTotalPagePlaceholder();
        result = result * 59 + ($isReplaceTotalPagePlaceholder == null ? 43 : ((Object)$isReplaceTotalPagePlaceholder).hashCode());
        Float $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Integer $totalPage = this.getTotalPage();
        result = result * 59 + ($totalPage == null ? 43 : ((Object)$totalPage).hashCode());
        Float $globalMarginLeft = this.getGlobalMarginLeft();
        result = result * 59 + ($globalMarginLeft == null ? 43 : ((Object)$globalMarginLeft).hashCode());
        Float $globalMarginRight = this.getGlobalMarginRight();
        result = result * 59 + ($globalMarginRight == null ? 43 : ((Object)$globalMarginRight).hashCode());
        Float $globalMarginTop = this.getGlobalMarginTop();
        result = result * 59 + ($globalMarginTop == null ? 43 : ((Object)$globalMarginTop).hashCode());
        Float $globalMarginBottom = this.getGlobalMarginBottom();
        result = result * 59 + ($globalMarginBottom == null ? 43 : ((Object)$globalMarginBottom).hashCode());
        Boolean $isReset = this.getIsReset();
        result = result * 59 + ($isReset == null ? 43 : ((Object)$isReset).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        XEasyPdfDefaultFontStyle $defaultFontStyle = this.getDefaultFontStyle();
        result = result * 59 + ($defaultFontStyle == null ? 43 : ((Object)((Object)$defaultFontStyle)).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Map<String, PDFont> $fontCache = this.getFontCache();
        result = result * 59 + ($fontCache == null ? 43 : ((Object)$fontCache).hashCode());
        Map<String, PDFont> $otfFontCache = this.getOtfFontCache();
        result = result * 59 + ($otfFontCache == null ? 43 : ((Object)$otfFontCache).hashCode());
        PDDocument $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        PDDocument $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        List<String> $tempTargetList = this.getTempTargetList();
        result = result * 59 + ($tempTargetList == null ? 43 : ((Object)$tempTargetList).hashCode());
        String $tempDir = this.getTempDir();
        result = result * 59 + ($tempDir == null ? 43 : $tempDir.hashCode());
        List<XEasyPdfDocument> $mergeSourceList = this.getMergeSourceList();
        result = result * 59 + ($mergeSourceList == null ? 43 : ((Object)$mergeSourceList).hashCode());
        List<XEasyPdfPage> $pageList = this.getPageList();
        result = result * 59 + ($pageList == null ? 43 : ((Object)$pageList).hashCode());
        Color $globalBackgroundColor = this.getGlobalBackgroundColor();
        result = result * 59 + ($globalBackgroundColor == null ? 43 : ((Object)$globalBackgroundColor).hashCode());
        XEasyPdfImage $globalBackgroundImage = this.getGlobalBackgroundImage();
        result = result * 59 + ($globalBackgroundImage == null ? 43 : ((Object)$globalBackgroundImage).hashCode());
        XEasyPdfWatermark $globalWatermark = this.getGlobalWatermark();
        result = result * 59 + ($globalWatermark == null ? 43 : $globalWatermark.hashCode());
        XEasyPdfHeader $globalHeader = this.getGlobalHeader();
        result = result * 59 + ($globalHeader == null ? 43 : $globalHeader.hashCode());
        XEasyPdfFooter $globalFooter = this.getGlobalFooter();
        result = result * 59 + ($globalFooter == null ? 43 : $globalFooter.hashCode());
        XEasyPdfDocumentPermission $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
        XEasyPdfDocumentInfo $documentInfo = this.getDocumentInfo();
        result = result * 59 + ($documentInfo == null ? 43 : $documentInfo.hashCode());
        XEasyPdfDocumentBookmark $bookmark = this.getBookmark();
        result = result * 59 + ($bookmark == null ? 43 : $bookmark.hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfDocumentParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContext=" + this.getIsResetContext() + ", isReplaceTotalPagePlaceholder=" + this.getIsReplaceTotalPagePlaceholder() + ", defaultFontStyle=" + (Object)((Object)this.getDefaultFontStyle()) + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontCache=" + this.getFontCache() + ", otfFontCache=" + this.getOtfFontCache() + ", source=" + this.getSource() + ", target=" + this.getTarget() + ", tempTargetList=" + this.getTempTargetList() + ", tempDir=" + this.getTempDir() + ", version=" + this.getVersion() + ", totalPage=" + this.getTotalPage() + ", mergeSourceList=" + this.getMergeSourceList() + ", pageList=" + this.getPageList() + ", globalMarginLeft=" + this.getGlobalMarginLeft() + ", globalMarginRight=" + this.getGlobalMarginRight() + ", globalMarginTop=" + this.getGlobalMarginTop() + ", globalMarginBottom=" + this.getGlobalMarginBottom() + ", globalBackgroundColor=" + this.getGlobalBackgroundColor() + ", globalBackgroundImage=" + this.getGlobalBackgroundImage() + ", globalWatermark=" + this.getGlobalWatermark() + ", globalHeader=" + this.getGlobalHeader() + ", globalFooter=" + this.getGlobalFooter() + ", permission=" + this.getPermission() + ", documentInfo=" + this.getDocumentInfo() + ", bookmark=" + this.getBookmark() + ", isReset=" + this.getIsReset() + ")";
    }
}

