/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.text;

import java.awt.Color;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.XEasyPdfComponentEvent;
import wiki.xsx.core.pdf.component.XEasyPdfPagingCondition;
import wiki.xsx.core.pdf.component.text.XEasypdfTextRenderingMode;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;
import wiki.xsx.core.pdf.util.XEasyPdfTextUtil;

abstract class XEasyPdfTextBase
implements XEasyPdfComponent {
    private static final long serialVersionUID = 3126411220662964797L;
    private XEasyPdfComponentEvent beforeEvent;
    private XEasyPdfComponentEvent afterEvent;

    XEasyPdfTextBase() {
    }

    @Override
    public abstract XEasyPdfTextBase setPosition(float var1, float var2);

    @Override
    public abstract XEasyPdfTextBase setWidth(float var1);

    @Override
    public abstract XEasyPdfTextBase setHeight(float var1);

    @Override
    public abstract XEasyPdfTextBase setContentMode(XEasyPdfComponent.ContentMode var1);

    @Override
    public abstract XEasyPdfTextBase enableResetContext();

    abstract void setBeginX(Float var1);

    abstract void setBeginY(Float var1);

    abstract XEasyPdfTextBase setPagingCondition(XEasyPdfPagingCondition var1);

    abstract XEasyPdfTextBase setNeedInitialize(boolean var1);

    abstract XEasyPdfComponent.ContentMode getContentMode();

    abstract float getHeight(XEasyPdfDocument var1, XEasyPdfPage var2);

    abstract float getWidth(XEasyPdfDocument var1, XEasyPdfPage var2);

    abstract float getBeginY();

    abstract float getMarginTop();

    abstract float getMarginBottom();

    abstract float getMarginLeft();

    abstract float getMarginRight();

    abstract List<String> getSplitTextList();

    abstract float getFontSize();

    abstract String getFontPath();

    abstract float getLeading();

    abstract float getCharacterSpacing();

    abstract float getAlpha();

    abstract Integer getIndent();

    abstract String getLinkUrl();

    abstract String getComment();

    abstract Color getFontColor();

    abstract Color getHighlightColor();

    abstract Color getUnderlineColor();

    abstract Color getDeleteLineColor();

    abstract float getUnderlineWidth();

    abstract float getDeleteLineWidth();

    abstract XEasypdfTextRenderingMode getRenderingMode();

    abstract XEasyPdfPagingCondition getPagingCondition();

    abstract boolean isUseSelfStyle();

    abstract boolean isNeedInitialize();

    abstract boolean isResetContext();

    abstract boolean isNewLine();

    abstract boolean isTextAppend();

    abstract boolean isHighlight();

    abstract boolean isUnderline();

    abstract boolean isDeleteLine();

    abstract boolean isCheckPage();

    abstract void init(XEasyPdfDocument var1, XEasyPdfPage var2);

    abstract float initBeginX(XEasyPdfDocument var1, XEasyPdfPage var2, String var3);

    public void onBeforeDraw(XEasyPdfComponentEvent event) {
        this.beforeEvent = event;
    }

    public void onAfterDraw(XEasyPdfComponentEvent event) {
        this.afterEvent = event;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.beforeEvent != null) {
            this.beforeEvent.execute(document, page, this);
        }
        this.doDraw(document, page);
        if (this.afterEvent != null) {
            this.afterEvent.execute(document, page, this);
        }
    }

    abstract void addText(PDFont var1, XEasyPdfPage var2, PDPageContentStream var3, String var4, float var5, float var6);

    PDPageContentStream initPageContentStream(XEasyPdfDocument document, XEasyPdfPage page, PDFont font) {
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.getContentMode().getMode(), true, this.isResetContext());
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        state.setNonStrokingAlphaConstant(Float.valueOf(this.getAlpha()));
        state.setAlphaSourceFlag(true);
        contentStream.setGraphicsStateParameters(state);
        contentStream.setFont(font, this.getFontSize());
        contentStream.setRenderingMode(this.getRenderingMode().getMode());
        contentStream.setLeading(this.getLeading());
        contentStream.setCharacterSpacing(this.getCharacterSpacing());
        return contentStream;
    }

    void doDraw(XEasyPdfDocument document, XEasyPdfPage page) {
        if (!this.isNewLine()) {
            page.disablePosition();
        }
        this.init(document, page);
        List<String> splitTextList = this.getSplitTextList();
        int totalLineIndex = splitTextList.size() - 1;
        PDFont font = XEasyPdfFontUtil.loadFont(document, page, this.getFontPath(), true);
        PDPageContentStream stream = null;
        float beginX = 0.0f;
        int index = 0;
        for (String text : splitTextList) {
            beginX = this.initBeginX(document, page, text);
            if (index == 0 && this.getIndent() != null) {
                beginX += (float)this.getIndent().intValue() * (this.getFontSize() + this.getCharacterSpacing());
            }
            stream = this.writeText(document, page, this.checkPage(document, page, stream), text, beginX, this.getBeginY(), index == totalLineIndex);
            if (this.isTextAppend()) {
                this.setBeginX(Float.valueOf(0.0f));
            }
            ++index;
        }
        if (stream != null) {
            if (totalLineIndex > -1) {
                this.setBeginY(Float.valueOf(this.getBeginY() + this.getFontSize() + this.getLeading()));
                float textWidth = this.getFontSize() * font.getStringWidth(splitTextList.get(totalLineIndex)) / 1000.0f;
                page.setPageX(Float.valueOf(beginX + textWidth));
            }
            stream.close();
            if (page.isAllowResetPosition()) {
                page.setPageY(Float.valueOf(this.getBeginY()));
            }
        }
        if (!page.isAllowResetPosition()) {
            page.enablePosition();
        }
    }

    PDPageContentStream checkPage(XEasyPdfDocument document, XEasyPdfPage page, PDPageContentStream stream) {
        if (this.isCheckPage()) {
            boolean pagingFlag;
            float footerHeight = 0.0f;
            if (page.isAllowFooter() && page.getFooter() != null) {
                footerHeight = page.getFooter().getHeight(document, page);
            }
            boolean bl = pagingFlag = this.getBeginY() - footerHeight < this.getMarginBottom();
            if (!pagingFlag && this.getPagingCondition() != null) {
                pagingFlag = this.getPagingCondition().isPaging(document, page, Float.valueOf(this.getBeginY()));
            }
            if (pagingFlag) {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
                PDRectangle rectangle = page.getLastPage().getMediaBox();
                page.addNewPage(document, rectangle);
                this.setBeginY(Float.valueOf(page.getPageY() == null ? rectangle.getHeight() - this.getMarginTop() - this.getFontSize() - this.getLeading() : page.getPageY().floatValue() - this.getMarginTop() - this.getFontSize() - this.getLeading()));
            }
        }
        return stream;
    }

    PDPageContentStream writeText(XEasyPdfDocument document, XEasyPdfPage page, PDPageContentStream stream, String text, float beginX, float beginY, boolean isLast) {
        PDFont font = XEasyPdfFontUtil.loadFont(document, page, this.getFontPath(), true);
        if (stream == null) {
            stream = this.initPageContentStream(document, page, font);
        }
        this.addComment(font, page, text, beginX, beginY, isLast);
        this.addLink(font, page, text, beginX, beginY);
        this.addHighlight(font, page, stream, text, beginX, beginY);
        this.initFontColor(page, stream);
        this.addText(font, page, stream, text, beginX, beginY);
        this.addUnderline(font, page, stream, text, beginX, beginY);
        this.addDeleteLine(font, page, stream, text, beginX, beginY);
        this.setBeginY(Float.valueOf(this.getBeginY() - this.getFontSize() - this.getLeading()));
        return stream;
    }

    void addLink(PDFont font, XEasyPdfPage page, String text, float beginX, float beginY) {
        String linkUrl = this.getLinkUrl();
        if (linkUrl != null && linkUrl.trim().length() > 0) {
            PDActionURI action = new PDActionURI();
            action.setURI(this.getLinkUrl());
            PDAnnotationLink link = new PDAnnotationLink();
            link.setAnnotationName(UUID.randomUUID().toString());
            link.setAction((PDAction)action);
            link.setRectangle(this.getRectangleForWrite(font, text, beginX, beginY));
            page.getLastPage().getAnnotations().add(link);
        }
    }

    void addComment(PDFont font, XEasyPdfPage page, String text, float beginX, float beginY, boolean isLast) {
        String content = this.getComment();
        if (content != null && content.trim().length() > 0 && isLast) {
            PDAnnotationText comment = new PDAnnotationText();
            comment.setAnnotationName(UUID.randomUUID().toString());
            comment.setContents(content);
            comment.setName("Comment");
            comment.setCreationDate((Calendar)new GregorianCalendar());
            comment.setRectangle(this.getRectangleForWrite(font, text, beginX, beginY));
            page.getLastPage().getAnnotations().add(comment);
        }
    }

    void addHighlight(PDFont font, XEasyPdfPage page, PDPageContentStream stream, String text, float beginX, float beginY) {
        if (this.isHighlight()) {
            PDRectangle rectangle = this.getRectangleForWrite(font, text, beginX, beginY -= this.getFontSize() / 10.0f);
            stream.addRect(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getWidth(), rectangle.getHeight());
            stream.setNonStrokingColor(this.getHighlightColor());
            stream.fill();
            stream.setNonStrokingColor(page.getBackgroundColor());
        }
    }

    void addUnderline(PDFont font, XEasyPdfPage page, PDPageContentStream stream, String text, float beginX, float beginY) {
        if (this.isUnderline()) {
            beginY = beginY - this.getUnderlineWidth() / 2.0f - this.getFontSize() / 10.0f;
            PDRectangle rectangle = this.getRectangleForWrite(font, text, beginX, beginY);
            stream.setStrokingColor(this.getUnderlineColor());
            stream.setLineWidth(this.getUnderlineWidth());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            stream.stroke();
            stream.setStrokingColor(page.getBackgroundColor());
        }
    }

    void addDeleteLine(PDFont font, XEasyPdfPage page, PDPageContentStream stream, String text, float beginX, float beginY) {
        if (this.isDeleteLine()) {
            beginY = beginY - this.getDeleteLineWidth() / 2.0f + this.getFontSize() / 2.0f;
            PDRectangle rectangle = this.getRectangleForWrite(font, text, beginX, beginY);
            stream.setStrokingColor(this.getDeleteLineColor());
            stream.setLineWidth(this.getDeleteLineWidth());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            stream.stroke();
            stream.setStrokingColor(page.getBackgroundColor());
        }
    }

    void initFontColor(XEasyPdfPage page, PDPageContentStream stream) {
        if (this.getRenderingMode().isFill()) {
            stream.setNonStrokingColor(this.getFontColor());
        }
        if (this.getRenderingMode().isStroke()) {
            stream.setStrokingColor(this.getFontColor());
        }
        if (this.getRenderingMode().isLight()) {
            stream.setStrokingColor(page.getBackgroundColor());
            stream.setNonStrokingColor(this.getFontColor());
        }
    }

    PDRectangle getRectangleForWrite(PDFont font, String text, float beginX, float beginY) {
        PDRectangle rectangle = new PDRectangle();
        rectangle.setLowerLeftX(beginX);
        rectangle.setLowerLeftY(beginY);
        rectangle.setUpperRightY(beginY + this.getFontSize());
        if (this.getRadians() > 0.0f) {
            rectangle.setUpperRightX(beginX + this.getFontSize() * (float)text.length());
        } else {
            rectangle.setUpperRightX(beginX + XEasyPdfTextUtil.getTextRealWidth(text, font, this.getFontSize(), this.getCharacterSpacing()));
        }
        return rectangle;
    }

    float getRadians() {
        return 0.0f;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfTextBase)) {
            return false;
        }
        XEasyPdfTextBase other = (XEasyPdfTextBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XEasyPdfComponentEvent this$beforeEvent = this.beforeEvent;
        XEasyPdfComponentEvent other$beforeEvent = other.beforeEvent;
        if (this$beforeEvent == null ? other$beforeEvent != null : !this$beforeEvent.equals(other$beforeEvent)) {
            return false;
        }
        XEasyPdfComponentEvent this$afterEvent = this.afterEvent;
        XEasyPdfComponentEvent other$afterEvent = other.afterEvent;
        return !(this$afterEvent == null ? other$afterEvent != null : !this$afterEvent.equals(other$afterEvent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfTextBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XEasyPdfComponentEvent $beforeEvent = this.beforeEvent;
        result = result * 59 + ($beforeEvent == null ? 43 : $beforeEvent.hashCode());
        XEasyPdfComponentEvent $afterEvent = this.afterEvent;
        result = result * 59 + ($afterEvent == null ? 43 : $afterEvent.hashCode());
        return result;
    }
}

