/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.layout.XEasyPdfLayout;
import wiki.xsx.core.pdf.component.layout.XEasyPdfLayoutComponent;
import wiki.xsx.core.pdf.component.layout.XEasyPdfLayoutParam;
import wiki.xsx.core.pdf.component.table.XEasyPdfCell;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTable;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;

public class XEasyPdfVerticalLayout
implements XEasyPdfLayout {
    private static final long serialVersionUID = -6412230973258885503L;
    private final XEasyPdfLayoutParam param = new XEasyPdfLayoutParam();

    @Override
    public XEasyPdfVerticalLayout setPosition(float beginX, float beginY) {
        this.param.getTable().setPosition(beginX, beginY);
        return this;
    }

    @Override
    public XEasyPdfVerticalLayout setWidth(float width) {
        this.param.setWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfVerticalLayout setHeight(float height) {
        this.param.setHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    @Override
    public XEasyPdfVerticalLayout setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.getTable().setContentMode(mode);
        return this;
    }

    public XEasyPdfVerticalLayout setMarginLeft(float marginLeft) {
        this.param.getTable().setMarginLeft(marginLeft);
        return this;
    }

    public XEasyPdfVerticalLayout setMarginTop(float marginTop) {
        this.param.getTable().setMarginTop(marginTop);
        return this;
    }

    @Override
    public XEasyPdfVerticalLayout enableBorder() {
        this.param.setHasTableBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfVerticalLayout enableResetContext() {
        this.param.getTable().enableResetContext();
        return this;
    }

    @Override
    public XEasyPdfVerticalLayout addLayoutComponent(XEasyPdfLayoutComponent ... components) {
        if (components != null) {
            Collections.addAll(this.param.getComponents(), components);
        }
        return this;
    }

    @Override
    public XEasyPdfVerticalLayout addLayoutComponent(List<XEasyPdfLayoutComponent> components) {
        if (components != null) {
            this.param.getComponents().addAll(components);
        }
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.param.getComponents().isEmpty()) {
            return;
        }
        List<XEasyPdfLayoutComponent> components = this.param.getComponents();
        ArrayList<XEasyPdfRow> rows = new ArrayList<XEasyPdfRow>(components.size());
        for (XEasyPdfLayoutComponent layoutComponent : components) {
            rows.add(new XEasyPdfRow(new XEasyPdfCell[0]).addCell(new XEasyPdfCell(layoutComponent.getWidth().floatValue(), layoutComponent.getHeight().floatValue()).addContent(layoutComponent.getComponent()).enableComponentSelfStyle()));
        }
        XEasyPdfTable table = this.param.getTable();
        if (!this.param.getHasTableBorder().booleanValue()) {
            table.disableBorder();
        }
        table.addRow(rows).setMarginBottom(0.0f).draw(document, page);
    }
}

