/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.layout.XEasyPdfLayout;
import wiki.xsx.core.pdf.component.layout.XEasyPdfLayoutComponent;
import wiki.xsx.core.pdf.component.layout.XEasyPdfLayoutParam;
import wiki.xsx.core.pdf.component.table.XEasyPdfCell;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTable;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;

public class XEasyPdfHorizontalLayout
implements XEasyPdfLayout {
    private static final long serialVersionUID = 5850233027447702010L;
    private final XEasyPdfLayoutParam param = new XEasyPdfLayoutParam();

    @Override
    public XEasyPdfHorizontalLayout setPosition(float beginX, float beginY) {
        this.param.getTable().setPosition(beginX, beginY);
        return this;
    }

    @Override
    public XEasyPdfHorizontalLayout setWidth(float width) {
        this.param.setWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfHorizontalLayout setHeight(float height) {
        this.param.setHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    @Override
    public XEasyPdfHorizontalLayout setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.getTable().setContentMode(mode);
        return this;
    }

    public XEasyPdfHorizontalLayout setMarginLeft(float marginLeft) {
        this.param.getTable().setMarginLeft(marginLeft);
        return this;
    }

    public XEasyPdfHorizontalLayout setMarginTop(float marginTop) {
        this.param.getTable().setMarginTop(marginTop);
        return this;
    }

    @Override
    public XEasyPdfHorizontalLayout enableBorder() {
        this.param.setHasTableBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfHorizontalLayout enableResetContext() {
        this.param.getTable().enableResetContext();
        return this;
    }

    @Override
    public XEasyPdfHorizontalLayout addLayoutComponent(XEasyPdfLayoutComponent ... components) {
        if (components != null) {
            Collections.addAll(this.param.getComponents(), components);
        }
        return this;
    }

    @Override
    public XEasyPdfHorizontalLayout addLayoutComponent(List<XEasyPdfLayoutComponent> components) {
        if (components != null) {
            this.param.getComponents().addAll(components);
        }
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.param.getComponents().isEmpty()) {
            return;
        }
        List<XEasyPdfLayoutComponent> components = this.param.getComponents();
        ArrayList<XEasyPdfCell> cells = new ArrayList<XEasyPdfCell>(components.size());
        for (XEasyPdfLayoutComponent layoutComponent : components) {
            cells.add(new XEasyPdfCell(layoutComponent.getWidth().floatValue(), layoutComponent.getHeight().floatValue()).addContent(layoutComponent.getComponent()).enableComponentSelfStyle());
        }
        XEasyPdfTable table = this.param.getTable();
        if (!this.param.getHasTableBorder().booleanValue()) {
            table.disableBorder();
        }
        table.addRow(new XEasyPdfRow(new XEasyPdfCell[0]).addCell(cells)).setMarginBottom(0.0f).draw(document, page);
    }
}

