package wiki.xsx.core.pdf.template.component.table;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import wiki.xsx.core.pdf.template.component.XEasyPdfTemplateComponentParam;

/**
 * pdf模板-表格参数
 *
 * @author xsx
 * @date 2022/8/22
 * @since 1.8
 * <p>
 * Copyright (c) 2020-2022 xsx All Rights Reserved.
 * x-easypdf is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 * </p>
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
class XEasyPdfTemplateTableParam extends XEasyPdfTemplateComponentParam {
    /**
     * 宽度
     */
    private String width;
    /**
     * 高度
     */
    private String height;
    /**
     * 最小列宽
     */
    private String minColumnWidth;
    /**
     * 最小行高
     */
    private String minRowHeight;
    /**
     * 边框折叠
     */
    protected String borderCollapse;
    /**
     * 边框间距
     */
    protected String borderSpacing;
    /**
     * 边框
     */
    protected String border;
    /**
     * 表头
     */
    private XEasyPdfTemplateTableHeader header;
    /**
     * 表格体
     */
    private XEasyPdfTemplateTableBody body;
    /**
     * 表尾
     */
    private XEasyPdfTemplateTableFooter footer;
}
