package wiki.xsx.core.pdf.template;

/**
 * pdf模板属性
 *
 * @author xsx
 * @date 2022/8/27
 * @since 1.8
 * <p>
 * Copyright (c) 2020-2022 xsx All Rights Reserved.
 * x-easypdf is licensed under the Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 * </p>
 */
public class XEasyPdfTemplateAttributes {
    /**
     * 页面名称
     */
    public static final String MASTER_NAME = "master-name";
    /**
     * 页面参考
     */
    public static final String MASTER_REFERENCE = "master-reference";
    /**
     * 页面流向
     */
    public static final String FLOW_NAME = "flow-name";
    /**
     * 页面宽度
     */
    public static final String PAGE_WIDTH = "page-width";
    /**
     * 页面高度
     */
    public static final String PAGE_HEIGHT = "page-height";
    /**
     * 区域范围
     */
    public static final String EXTENT = "extent";
    /**
     * 边距（上下左右）
     */
    public static final String MARGIN = "margin";
    /**
     * 上边距
     */
    public static final String MARGIN_TOP = "margin-top";
    /**
     * 下边距
     */
    public static final String MARGIN_BOTTOM = "margin-bottom";
    /**
     * 左边距
     */
    public static final String MARGIN_LEFT = "margin-left";
    /**
     * 右边距
     */
    public static final String MARGIN_RIGHT = "margin-right";
    /**
     * 填充（上下左右）
     */
    public static final String PADDING = "padding";
    /**
     * 上填充
     */
    public static final String PADDING_TOP = "padding-top";
    /**
     * 下填充
     */
    public static final String PADDING_BOTTOM = "padding-bottom";
    /**
     * 左填充
     */
    public static final String PADDING_LEFT = "padding-left";
    /**
     * 右填充
     */
    public static final String PADDING_RIGHT = "padding-right";
    /**
     * 宽度
     */
    public static final String WIDTH = "width";
    /**
     * 高度
     */
    public static final String HEIGHT = "height";
    /**
     * 文本对齐
     */
    public static final String TEXT_ALIGN = "text-align";
    /**
     * 显示对齐
     */
    public static final String DISPLAY_ALIGN = "display-align";
    /**
     * 边框
     */
    public static final String BORDER = "border";
    /**
     * 边框样式
     */
    public static final String BORDER_STYLE = "border-style";
    /**
     * 边框折叠
     */
    public static final String BORDER_COLLAPSE = "border-collapse";
    /**
     * 边框间距
     */
    public static final String BORDER_SPACING = "border-spacing";
    /**
     * 颜色
     */
    public static final String COLOR = "color";
    /**
     * 字体家族
     */
    public static final String FONT_FAMILY = "font-family";
    /**
     * 字体样式
     */
    public static final String FONT_STYLE = "font-style";
    /**
     * 字体大小
     */
    public static final String FONT_SIZE = "font-size";
    /**
     * 字体大小调整
     */
    public static final String FONT_SIZE_ADJUST = "font-size-adjust";
    /**
     * 字体重量
     */
    public static final String FONT_WEIGHT = "font-weight";
    /**
     * 行间距
     */
    public static final String LINE_HEIGHT = "line-height";
    /**
     * 字符间距
     */
    public static final String LETTER_SPACING = "letter-spacing";
    /**
     * 来源
     */
    public static final String SRC = "src";
    /**
     * 图像宽度
     */
    public static final String CONTENT_WIDTH = "content-width";
    /**
     * 图像高度
     */
    public static final String CONTENT_HEIGHT = "content-height";
}
