/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import uk.co.westhawk.snmp.beans.UsmDiscoveryBean;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextv3;
import uk.co.westhawk.snmp.stack.TimeWindow;
import uk.co.westhawk.snmp.stack.TimeWindowNode;
import uk.co.westhawk.snmp.stack.UsmAgent;

public class DefaultUsmAgent
implements UsmAgent {
    static final String version_id = "@(#)$Id: DefaultUsmAgent.java,v 3.3 2002/10/10 15:13:57 birgit Exp $ Copyright Westhawk Ltd";
    public static final String LOCAL_HOST = "localhost";
    public static final int LOCAL_PORT = 161;
    private SnmpContextv3 context;
    private String hostname = "localhost";
    private int port = 161;

    public String getSnmpEngineId() {
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostname, this.port);
        return engineId;
    }

    public int getSnmpEngineBoots() {
        int boots = 1;
        TimeWindowNode node = null;
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostname, this.port);
        if (engineId != null) {
            node = tWindow.getTimeLine(engineId);
        }
        if (node != null) {
            boots = node.getSnmpEngineBoots();
        }
        return boots;
    }

    public int getSnmpEngineTime() {
        int time = 1;
        TimeWindowNode node = null;
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostname, this.port);
        if (engineId != null) {
            node = tWindow.getTimeLine(engineId);
        }
        if (node != null) {
            time = node.getSnmpEngineTime();
        }
        return time;
    }

    public void setSnmpContext(SnmpContextv3 c) {
        block4: {
            this.context = c;
            try {
                this.discoverIfNeeded();
            }
            catch (PduException exc) {
                if (AsnObject.debug > 4) {
                    System.out.println("DefaultUsmAgent.setSnmpContext():" + exc.getMessage());
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 4) break block4;
                System.out.println("DefaultUsmAgent.setSnmpContext():" + exc.getMessage());
            }
        }
    }

    public void setAgentName(String host) {
        this.hostname = host;
    }

    public void setAgentPort(int p) {
        this.port = p;
    }

    void discoverIfNeeded() throws IOException, PduException {
        UsmDiscoveryBean discBean = null;
        boolean isNeeded = false;
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostname, this.port);
        if (engineId == null) {
            isNeeded = true;
            discBean = new UsmDiscoveryBean(this.hostname, this.port, this.context.getTypeSocket());
        }
        if (this.context.isUseAuthentication()) {
            if (isNeeded) {
                discBean.setAuthenticationDetails(this.context.getUserName(), this.context.getUserAuthenticationPassword(), this.context.getAuthenticationProtocol());
            } else if (!tWindow.isTimeLineKnown(engineId)) {
                isNeeded = true;
                discBean = new UsmDiscoveryBean(this.hostname, this.port, this.context.getTypeSocket());
                discBean.setAuthenticationDetails(this.context.getUserName(), this.context.getUserAuthenticationPassword(), this.context.getAuthenticationProtocol());
            }
            if (isNeeded && this.context.isUsePrivacy()) {
                discBean.setPrivacyDetails(this.context.getUserPrivacyPassword());
            }
        }
        if (isNeeded) {
            discBean.startDiscovery();
        }
    }
}

