/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextv2c;
import uk.co.westhawk.snmp.stack.SnmpContextv3;
import uk.co.westhawk.snmp.stack.TimeWindowNode;
import uk.co.westhawk.snmp.stack.varbind;
import uk.co.westhawk.snmp.util.SnmpUtilities;

class AsnEncoder {
    private static final String version_id = "@(#)$Id: AsnEncoder.java,v 3.22 2002/10/10 15:13:57 birgit Exp $ Copyright Westhawk Ltd";
    static byte[] dummyFingerPrint = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    AsnEncoder() {
    }

    byte[] EncodeSNMPv3(SnmpContextv3 context, int contextMsgId, TimeWindowNode node, byte msg_type, int pduId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        ByteArrayOutputStream bout;
        AsnOctets privOct;
        AsnSequence asnTopSeq = new AsnSequence();
        AsnSequence asnHeaderData = new AsnSequence();
        asnHeaderData.add(new AsnInteger(contextMsgId));
        asnHeaderData.add(new AsnInteger(context.getMaxRecvSize()));
        asnHeaderData.add(new AsnOctets(this.getMsgFlags(context)));
        asnHeaderData.add(new AsnInteger(3));
        AsnSequence asnPlainScopedPdu = new AsnSequence();
        asnPlainScopedPdu.add(new AsnOctets(context.getContextEngineId()));
        asnPlainScopedPdu.add(new AsnOctets(context.getContextName()));
        AsnObject asnPduObject = this.EncodePdu(msg_type, pduId, errstat, errind, ve);
        asnPlainScopedPdu.add(asnPduObject);
        if (AsnObject.debug > 10) {
            System.out.println("\nEncode USM: node " + node.toString());
        }
        AsnSequence asnSecurityObject = new AsnSequence();
        byte[] engineIdBytes = SnmpUtilities.toBytes(node.getSnmpEngineId());
        asnSecurityObject.add(new AsnOctets(engineIdBytes));
        asnSecurityObject.add(new AsnInteger(node.getSnmpEngineBoots()));
        asnSecurityObject.add(new AsnInteger(node.getSnmpEngineTime()));
        asnSecurityObject.add(new AsnOctets(context.getUserName()));
        AsnOctets fingerPrintOct = context.isUseAuthentication() ? new AsnOctets(dummyFingerPrint) : new AsnOctets("");
        asnSecurityObject.add(fingerPrintOct);
        AsnOctets asnEncryptedScopedPdu = null;
        if (context.isUsePrivacy()) {
            byte[] passwKey;
            byte[] privKey = null;
            int prot = context.getAuthenticationProtocol();
            if (prot == 0) {
                passwKey = context.getPrivacyPasswordKeyMD5();
                privKey = SnmpUtilities.getLocalizedKeyMD5(passwKey, node.getSnmpEngineId());
            } else {
                passwKey = context.getPrivacyPasswordKeySHA1();
                privKey = SnmpUtilities.getLocalizedKeySHA1(passwKey, node.getSnmpEngineId());
            }
            byte[] salt = SnmpUtilities.getSaltDES(node.getSnmpEngineBoots());
            privOct = new AsnOctets(salt);
            bout = new ByteArrayOutputStream();
            asnPlainScopedPdu.write(bout);
            byte[] plaintext = bout.toByteArray();
            byte[] encryptedText = SnmpUtilities.encrypt(plaintext, privKey, salt);
            asnEncryptedScopedPdu = new AsnOctets(encryptedText);
        } else {
            privOct = new AsnOctets("");
        }
        asnSecurityObject.add(privOct);
        ByteArrayOutputStream secOut = new ByteArrayOutputStream();
        asnSecurityObject.write(secOut);
        byte[] bytes = secOut.toByteArray();
        AsnOctets asnSecurityParameters = new AsnOctets(bytes);
        asnTopSeq.add(new AsnInteger(3));
        asnTopSeq.add(asnHeaderData);
        asnTopSeq.add(asnSecurityParameters);
        if (context.isUsePrivacy()) {
            asnTopSeq.add(asnEncryptedScopedPdu);
        } else {
            asnTopSeq.add(asnPlainScopedPdu);
        }
        if (AsnObject.debug > 10) {
            System.out.println("\nAsnEncoder.EncodeSNMPv3(): ");
        }
        bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        int sz = bout.size();
        if (sz > context.getMaxRecvSize()) {
            throw new EncodingException("Packet size (" + sz + ") is > maximum size (" + context.getMaxRecvSize() + ")");
        }
        byte[] message = bout.toByteArray();
        if (context.isUseAuthentication()) {
            byte[] authkey;
            byte[] passwKey;
            byte[] calcFingerPrint = null;
            int prot = context.getAuthenticationProtocol();
            if (prot == 0) {
                passwKey = context.getAuthenticationPasswordKeyMD5();
                authkey = SnmpUtilities.getLocalizedKeyMD5(passwKey, node.getSnmpEngineId());
                calcFingerPrint = SnmpUtilities.getFingerPrintMD5(authkey, message);
            } else {
                passwKey = context.getAuthenticationPasswordKeySHA1();
                authkey = SnmpUtilities.getLocalizedKeySHA1(passwKey, node.getSnmpEngineId());
                calcFingerPrint = SnmpUtilities.getFingerPrintSHA1(authkey, message);
            }
            int usmPos = asnSecurityParameters.getContentsPos();
            int fpPos = fingerPrintOct.getContentsPos();
            fpPos += usmPos;
            if (AsnObject.debug > 10) {
                int fpLength = fingerPrintOct.getContentsLength();
                String str = "Pos finger print = " + fpPos + ", len = " + fpLength;
                SnmpUtilities.dumpBytes(str, calcFingerPrint);
            }
            System.arraycopy(calcFingerPrint, 0, message, fpPos, dummyFingerPrint.length);
        }
        return message;
    }

    ByteArrayOutputStream EncodeSNMPv2c(SnmpContextv2c context, byte msg_type, int pduId, int errstat, int errind, Enumeration ve) throws IOException {
        AsnSequence asnTopSeq = new AsnSequence();
        asnTopSeq.add(new AsnInteger(1));
        asnTopSeq.add(new AsnOctets(context.getCommunity()));
        AsnObject asnPduObject = this.EncodePdu(msg_type, pduId, errstat, errind, ve);
        asnTopSeq.add(asnPduObject);
        if (AsnObject.debug > 10) {
            System.out.println("\nAsnEncoder.EncodeSNMPv2c(): ");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        return bout;
    }

    ByteArrayOutputStream EncodeSNMP(SnmpContext context, byte msg_type, String enterprise, byte[] IpAddress, int generic_trap, int specific_trap, long timeTicks, Enumeration ve) throws IOException {
        AsnSequence asnTopSeq = new AsnSequence();
        asnTopSeq.add(new AsnInteger(0));
        asnTopSeq.add(new AsnOctets(context.getCommunity()));
        AsnObject asnPduObject = this.EncodeTrap1Pdu(msg_type, enterprise, IpAddress, generic_trap, specific_trap, timeTicks, ve);
        asnTopSeq.add(asnPduObject);
        if (AsnObject.debug > 10) {
            System.out.println("\nAsnEncoder.EncodeSNMP(): ");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        return bout;
    }

    private AsnObject EncodeTrap1Pdu(byte msg_type, String enterprise, byte[] IpAddress, int generic_trap, int specific_trap, long timeTicks, Enumeration ve) throws IOException {
        AsnSequence asnPduObject = new AsnSequence(msg_type);
        ((AsnObject)asnPduObject).add(new AsnObjectId(enterprise));
        ((AsnObject)asnPduObject).add(new AsnOctets(IpAddress, 64));
        ((AsnObject)asnPduObject).add(new AsnInteger(generic_trap));
        ((AsnObject)asnPduObject).add(new AsnInteger(specific_trap));
        ((AsnObject)asnPduObject).add(new AsnUnsInteger(timeTicks));
        AsnObject asnVBLObject = ((AsnObject)asnPduObject).add(new AsnSequence());
        while (ve.hasMoreElements()) {
            AsnObject asnVBObject = asnVBLObject.add(new AsnSequence());
            varbind vb = (varbind)ve.nextElement();
            asnVBObject.add(vb.getOid());
            asnVBObject.add(vb.getValue());
        }
        return asnPduObject;
    }

    ByteArrayOutputStream EncodeSNMP(SnmpContext context, byte msg_type, int pduId, int errstat, int errind, Enumeration ve) throws IOException {
        AsnSequence asnTopSeq = new AsnSequence();
        asnTopSeq.add(new AsnInteger(0));
        asnTopSeq.add(new AsnOctets(context.getCommunity()));
        AsnObject asnPduObject = this.EncodePdu(msg_type, pduId, errstat, errind, ve);
        asnTopSeq.add(asnPduObject);
        if (AsnObject.debug > 10) {
            System.out.println("\nAsnEncoder.EncodeSNMP(): ");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        return bout;
    }

    private AsnObject EncodePdu(byte msg_type, int pduId, int errstat, int errind, Enumeration ve) throws IOException {
        AsnSequence asnPduObject = new AsnSequence(msg_type);
        ((AsnObject)asnPduObject).add(new AsnInteger(pduId));
        ((AsnObject)asnPduObject).add(new AsnInteger(errstat));
        ((AsnObject)asnPduObject).add(new AsnInteger(errind));
        AsnObject asnVBLObject = ((AsnObject)asnPduObject).add(new AsnSequence());
        while (ve.hasMoreElements()) {
            AsnObject asnVBObject = asnVBLObject.add(new AsnSequence());
            varbind vb = (varbind)ve.nextElement();
            asnVBObject.add(vb.getOid());
            asnVBObject.add(vb.getValue());
        }
        return asnPduObject;
    }

    private byte[] getMsgFlags(SnmpContextv3 context) throws EncodingException {
        int authMask = 0;
        if (context.isUseAuthentication()) {
            authMask = 1;
        }
        int privMask = 0;
        if (context.isUsePrivacy()) {
            if (context.isUseAuthentication()) {
                privMask = 2;
            } else {
                throw new EncodingException("Encryption without authentication is not allowed");
            }
        }
        int reportMask = 4;
        byte[] msgFlags = new byte[]{(byte)(authMask | privMask | reportMask)};
        return msgFlags;
    }
}

