/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.Enumeration;
import uk.co.westhawk.snmp.event.TrapEvent;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.event.TrapReceivedSupport;
import uk.co.westhawk.snmp.net.ContextSocketFace;
import uk.co.westhawk.snmp.stack.AsnDecoder;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.DefaultTrapContext;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.Transmitter;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public abstract class AbstractSnmpContext
implements SnmpContextBasisFace,
Runnable,
TrapListener {
    private static final String version_id = "@(#)$Id: AbstractSnmpContext.java,v 3.22 2002/11/18 14:08:20 birgit Exp $ Copyright Westhawk Ltd";
    private ContextSocketFace soc;
    private Transmitter[] transmitters;
    private Pdu[] pdus = new Pdu[20];
    private Thread me;
    private String basename;
    protected String typeSocket;
    protected String hostAddr;
    protected int hostPort;
    protected int maxRecvSize;
    protected boolean isDestroyed;
    private TrapReceivedSupport trapSupport;

    protected abstract void ProcessIncomingMessage(AsnDecoder var1, ByteArrayInputStream var2) throws DecodingException, IOException;

    public abstract byte[] encodePacket(byte var1, int var2, int var3, int var4, Enumeration var5) throws IOException, EncodingException;

    public abstract Pdu processIncomingTrap(byte[] var1) throws DecodingException, IOException;

    public abstract int getVersion();

    protected AbstractSnmpContext(String host, int port) throws IOException {
        this(host, port, "Standard");
    }

    protected AbstractSnmpContext(String host, int port, String typeSocketA) throws IOException {
        this.hostAddr = host;
        this.hostPort = port;
        this.typeSocket = typeSocketA;
        this.transmitters = new Transmitter[20];
        this.basename = host + "_" + port;
        this.trapSupport = new TrapReceivedSupport(this);
        this.isDestroyed = false;
        this.maxRecvSize = 1300;
        this.soc = AbstractSnmpContext.getSocket(typeSocketA);
        this.soc.create(host, port);
        this.activate();
    }

    protected void activate() {
        if (this.me == null) {
            this.me = new Thread((Runnable)this, this.basename + "_Receive");
            this.me.setPriority(10);
            this.me.start();
        }
    }

    static ContextSocketFace getSocket(String type) throws IOException {
        ContextSocketFace sf = null;
        String className = "uk.co.westhawk.snmp.net.StandardSocket";
        if (type.equals("Netscape")) {
            className = "uk.co.westhawk.snmp.net.NetscapeSocket";
        } else if (type.equals("KVM")) {
            className = "uk.co.westhawk.snmp.net.KvmSocket";
        }
        try {
            Class<?> cl = Class.forName(className);
            Object obj = cl.newInstance();
            sf = (ContextSocketFace)obj;
        }
        catch (ClassNotFoundException exc) {
            String str = "ClassNotFound problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (InstantiationException exc) {
            String str = "Instantiation problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (IllegalAccessException exc) {
            String str = "IllegalAccess problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (ClassCastException exc) {
            String str = "ClassCast problem " + exc.getMessage();
            throw new IOException(str);
        }
        if (sf == null) {
            String str = "Cannot create socket ";
            throw new IOException(str);
        }
        if (AsnObject.debug > 12) {
            System.out.println("AbstractSnmpContext.getSocket(): New socket " + sf.getClass().getName());
        }
        return sf;
    }

    public String getHost() {
        return this.hostAddr;
    }

    public String getHostAddress() {
        return this.soc.getHostAddress();
    }

    public int getPort() {
        return this.hostPort;
    }

    public String getTypeSocket() {
        return this.typeSocket;
    }

    public int getMaxRecvSize() {
        return this.maxRecvSize;
    }

    public void setMaxRecvSize(int no) {
        this.maxRecvSize = no;
    }

    public String getDebugString() {
        char[] cret = new char[21];
        int i = 0;
        while (i < 20) {
            cret[i] = this.transmitters[i] != null ? (this.pdus[i] != null ? (int)(65 + this.pdus[i].getReqId() % 26) : 61) : 45;
            ++i;
        }
        int res = 48;
        if (this.me != null) {
            res = (char)(res + 1);
            if (this.me.isAlive()) {
                res = (char)(res + 1);
            }
        }
        cret[20] = res;
        return new String(cret);
    }

    public synchronized void destroy() {
        if (this.me != null) {
            this.me = null;
        }
        if (AsnObject.debug > 0) {
            System.out.println("AbstractSnmpContext.destroy(): Closing socket ");
        }
        this.soc.close();
        this.isDestroyed = true;
    }

    public synchronized void stop() {
        if (this.me != null) {
            this.me = null;
        }
    }

    public void run() {
        while (this.me != null) {
            AsnDecoder rpdu = new AsnDecoder();
            Thread.yield();
            try {
                if (this.me == null) break;
                ByteArrayInputStream in = this.soc.receive(this.maxRecvSize);
                if (AsnObject.debug > 10) {
                    int nb = in.available();
                    byte[] bu = new byte[nb];
                    in.read(bu);
                    in.reset();
                    SnmpUtilities.dumpBytes("Received from " + this.soc.getHostAddress() + ": ", bu);
                }
                this.ProcessIncomingMessage(rpdu, in);
            }
            catch (IOException exc) {
                if (exc instanceof InterruptedIOException) {
                    if (AsnObject.debug <= 15) continue;
                    System.out.println("AbstractSnmpContext.run(): Idle recv " + exc.getMessage());
                    continue;
                }
                if (exc instanceof SocketException) {
                    if (AsnObject.debug <= 15) continue;
                    System.out.println("AbstractSnmpContext.run(): SocketException " + exc.getMessage());
                    continue;
                }
                if (AsnObject.debug <= 0) continue;
                System.out.println("AbstractSnmpContext.run(): " + exc.getClass().getName() + " " + exc.getMessage());
                exc.printStackTrace();
            }
            catch (DecodingException exc) {
                if (AsnObject.debug <= 1) continue;
                System.out.println("AbstractSnmpContext.run(): DecodingException: " + exc.getMessage());
            }
            catch (Exception exc) {
                if (AsnObject.debug <= 1) continue;
                System.out.println("AbstractSnmpContext.run(): Exception: " + exc.getMessage());
                exc.printStackTrace();
            }
        }
        int i = 0;
        while (i < 20) {
            if (this.transmitters[i] != null) {
                this.transmitters[i].destroy();
                this.transmitters[i] = null;
            }
            if (this.pdus[i] != null) {
                this.pdus[i] = null;
            }
            ++i;
        }
        this.trapSupport.empty();
        try {
            DefaultTrapContext defaultTrapContext = DefaultTrapContext.getInstance(162, this.typeSocket);
            defaultTrapContext.removeTrapListener(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendPacket(byte[] p) {
        block3: {
            try {
                if (AsnObject.debug > 10) {
                    SnmpUtilities.dumpBytes("Sending to " + this.soc.getHostAddress() + ": ", p);
                }
                this.soc.send(p);
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println("AbstractSnmpContext.sendPacket(): IOException " + exc.getMessage());
            }
        }
    }

    Pdu getPdu(Integer ReqId) {
        return this.getPdu((int)ReqId);
    }

    Pdu getPdu(int rid) {
        Pdu ret = null;
        int i = 0;
        while (i < 20) {
            if (this.pdus[i] != null && this.pdus[i].getReqId() == rid) {
                ret = this.pdus[i];
                break;
            }
            ++i;
        }
        return ret;
    }

    public synchronized boolean removePdu(int rid) {
        boolean ret = false;
        int i = 0;
        while (i < 20) {
            if (this.pdus[i] != null && this.pdus[i].getReqId() == rid) {
                this.pdus[i] = null;
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    public synchronized boolean addPdu(Pdu p) throws IOException, PduException {
        boolean done = false;
        if (this.isDestroyed) {
            throw new EncodingException("Context can no longer be used, since it is already destroyed");
        }
        int i = 0;
        while (i < 20) {
            if (this.pdus[i] == null) {
                this.pdus[i] = p;
                this.pdus[i].setTrans(this.getTrans(i));
                done = true;
                break;
            }
            ++i;
        }
        return done;
    }

    public void addTrapListener(TrapListener l) throws IOException {
        DefaultTrapContext defaultTrapContext = DefaultTrapContext.getInstance(162, this.typeSocket);
        this.trapSupport.addTrapListener(l);
        defaultTrapContext.addTrapListener(this);
    }

    public void removeTrapListener(TrapListener l) throws IOException {
        DefaultTrapContext defaultTrapContext = DefaultTrapContext.getInstance(162, this.typeSocket);
        this.trapSupport.removeTrapListener(l);
        if (this.trapSupport.getListenerCount() == 0) {
            defaultTrapContext.removeTrapListener(this);
        }
    }

    public void trapReceived(TrapEvent evt) {
        String hostAddress = evt.getHostAddress();
        int version = evt.getVersion();
        if (version == this.getVersion()) {
            if (hostAddress != null && hostAddress.equals(this.getHostAddress())) {
                Pdu pdu;
                block11: {
                    byte[] message = evt.getMessage();
                    pdu = null;
                    try {
                        pdu = this.processIncomingTrap(message);
                    }
                    catch (DecodingException exc) {
                        if (AsnObject.debug > 2) {
                            System.out.println("AbstractSnmpContext.trapReceived(): DecodingException: " + exc.getMessage());
                        }
                    }
                    catch (IOException exc) {
                        if (AsnObject.debug <= 0) break block11;
                        System.out.println("AbstractSnmpContext.trapReceived(): IOException " + exc.getMessage());
                    }
                }
                if (pdu != null) {
                    evt.consume();
                    this.trapSupport.fireTrapReceived(pdu);
                }
            } else if (AsnObject.debug > 5) {
                System.out.println("AbstractSnmpContext.trapReceived(): Trap host (" + hostAddress + "), does not correspond with context host (" + this.getHostAddress() + ")");
            }
        } else if (AsnObject.debug > 5) {
            String theirs = SnmpUtilities.getSnmpVersionString(version);
            String ours = SnmpUtilities.getSnmpVersionString(this.getVersion());
            System.out.println("AbstractSnmpContext.trapReceived(): Trap version " + theirs + ", does not correspond with context version " + ours);
        }
    }

    Transmitter getTrans(int i) {
        if (this.transmitters[i] == null) {
            this.transmitters[i] = new Transmitter(this.basename + "_Trans" + i);
        }
        return this.transmitters[i];
    }
}

