/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.event;

import java.util.Vector;
import uk.co.westhawk.snmp.event.TrapEvent;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.stack.Pdu;

public class TrapReceivedSupport {
    public static final String version_id = "@(#)$Id: TrapReceivedSupport.java,v 1.3 2002/10/10 15:13:56 birgit Exp $ Copyright Westhawk Ltd";
    private Object source;
    private transient Vector trapListeners;

    public TrapReceivedSupport(Object src) {
        this.source = src;
    }

    public synchronized void empty() {
        if (this.trapListeners != null) {
            this.trapListeners.removeAllElements();
        }
    }

    public synchronized int getListenerCount() {
        int c = 0;
        if (this.trapListeners != null) {
            c = this.trapListeners.size();
        }
        return c;
    }

    public synchronized void addTrapListener(TrapListener listener) {
        if (this.trapListeners == null) {
            this.trapListeners = new Vector(5);
        }
        if (!this.trapListeners.contains(listener)) {
            this.trapListeners.addElement(listener);
        }
    }

    public synchronized void removeTrapListener(TrapListener listener) {
        if (this.trapListeners != null) {
            this.trapListeners.removeElement(listener);
        }
    }

    public boolean fireTrapReceived(int version, String hostAddress, byte[] message) {
        boolean isConsumed = false;
        Vector copyOfListeners = null;
        if (this.trapListeners != null) {
            Vector vector = this.trapListeners;
            synchronized (vector) {
                copyOfListeners = (Vector)this.trapListeners.clone();
            }
        }
        if (copyOfListeners != null) {
            int l = message.length;
            int sz = copyOfListeners.size();
            int i = sz - 1;
            while (i >= 0 && !isConsumed) {
                TrapListener listener = (TrapListener)copyOfListeners.elementAt(i);
                byte[] copyOfMessage = new byte[l];
                System.arraycopy(message, 0, copyOfMessage, 0, l);
                TrapEvent evt = new TrapEvent(this.source, version, hostAddress, copyOfMessage);
                listener.trapReceived(evt);
                isConsumed = evt.isConsumed();
                --i;
            }
        }
        return isConsumed;
    }

    public void fireTrapReceived(Pdu pdu) {
        Vector copyOfListeners = null;
        if (this.trapListeners != null) {
            Vector vector = this.trapListeners;
            synchronized (vector) {
                copyOfListeners = (Vector)this.trapListeners.clone();
            }
        }
        if (copyOfListeners != null) {
            int sz = copyOfListeners.size();
            int i = sz - 1;
            while (i >= 0) {
                TrapListener listener = (TrapListener)copyOfListeners.elementAt(i);
                TrapEvent evt = new TrapEvent(this.source, pdu);
                listener.trapReceived(evt);
                --i;
            }
        }
    }
}

