/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class DialogChannelStatusBean
extends SNMPRunBean
implements Observer,
TreeNode {
    private static final String version_id = "@(#)$Id: DialogChannelStatusBean.java,v 1.14 2002/10/10 15:13:56 birgit Exp $ Copyright Westhawk Ltd";
    public static final String dlgR4DeviceIndex = "1.3.6.1.4.1.3028.2.1.1.2.1.1.1";
    public static final String dlgR4DeviceName = "1.3.6.1.4.1.3028.2.1.1.2.1.1.2";
    public static final String dlgR4DeviceType = "1.3.6.1.4.1.3028.2.1.1.2.1.1.3";
    public static final String dlgR4DeviceOpenCount = "1.3.6.1.4.1.3028.2.1.1.2.1.1.5";
    public static final String dlgR4VoiceChannelStatus = "1.3.6.1.4.1.3028.2.1.1.2.2.1.2";
    private static final int NR_OID = 5;
    public static final int unknown = 1;
    public static final int voice = 2;
    public static final int dti = 3;
    public static final int isdn = 4;
    public static final int msi = 5;
    public static final int idle = 1;
    public static final int playing = 2;
    public static final int recording = 3;
    public static final int gettingDigits = 5;
    public static final int blocked = 16;
    public static final int dialing = 4;
    public static final int playTone = 6;
    public static final int sendingFax = 8;
    public static final int receivingFax = 9;
    public static final int betweenFAXPages = 10;
    public static final int hookState = 11;
    public static final int winking = 12;
    public static final int callProgess = 13;
    public static final int gettingR2MF = 14;
    public static final String[] vch_status = new String[]{"", "Channel not active", "Playing Audio Data", "Recording Audio Data", "Dialing Digits", "Collecting DTMF digits", "Playing a tone", "", "Sending a FAX (VFX boards)", "Receiving a FAX (VFX boards)", "Between FAX pages (VFX boards)", "Changing hook status to onhook or offhook", "Performing a wink", "Performing Call progress analysis", "Retrieving R2MF digits", "", "Blocked"};
    private GetNextPdu_vec pdu;
    private Hashtable channelIndexStatusHash = new Hashtable();
    private Hashtable channelHash = new Hashtable();
    private TreeNode parent;
    private DefaultTreeModel treeModel;
    private boolean isGetNextInFlight;
    private Date lastUpdateDate = null;
    private int deviceType = 0;
    private String deviceName = "";
    private int openCount = 0;
    private int channelStatus = 0;

    public DialogChannelStatusBean() {
    }

    public DialogChannelStatusBean(String h, int p) {
        this();
        this.setHost(h);
        this.setPort(p);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Enumeration getChannelIndexes() {
        return this.channelIndexStatusHash.keys();
    }

    public synchronized int getChannelCount() {
        return this.channelIndexStatusHash.size();
    }

    public String getChannelName(Integer index) {
        String name = "";
        Object obj = this.channelHash.get(index);
        if (obj != null) {
            ChannelStatus chSt = (ChannelStatus)obj;
            name = chSt.getName();
        }
        return name;
    }

    public int getChannelStatus(Integer index) {
        int status = 0;
        Object obj = this.channelIndexStatusHash.get(index);
        if (obj != null) {
            status = (Integer)obj;
        }
        return status;
    }

    public String getChannelStatusString(Integer index) {
        int status = this.getChannelStatus(index);
        String str = vch_status[status];
        return str;
    }

    public Enumeration children() {
        return this.channelHash.elements();
    }

    public int getChildCount() {
        int sz = this.channelHash.size();
        return sz;
    }

    public TreeNode getChildAt(int childIndex) {
        TreeNode node = null;
        if (childIndex < this.channelHash.size()) {
            Enumeration enumeration = this.channelHash.elements();
            int i = 0;
            while (i <= childIndex) {
                node = (TreeNode)enumeration.nextElement();
                ++i;
            }
        }
        return node;
    }

    public int getIndex(TreeNode node) {
        int ret = -1;
        if (this.channelHash.contains(node)) {
            boolean found = false;
            Enumeration enumeration = this.channelHash.elements();
            while (enumeration.hasMoreElements() && !found) {
                TreeNode n = (TreeNode)enumeration.nextElement();
                found = n == node;
                ++ret;
            }
        }
        return ret;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public void action() {
        if (this.isHostPortReachable()) {
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.setRunning(true);
        }
    }

    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isGetNextInFlight) {
                this.isGetNextInFlight = true;
                this.pdu = new GetNextPdu_vec(this.context, 5);
                this.pdu.addObserver(this);
                this.pdu.addOid(dlgR4DeviceIndex);
                this.pdu.addOid(dlgR4DeviceName);
                this.pdu.addOid(dlgR4DeviceType);
                this.pdu.addOid(dlgR4DeviceOpenCount);
                this.pdu.addOid(dlgR4VoiceChannelStatus);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(Observable obs, Object ov) {
        boolean hasEnded = false;
        this.pdu = (GetNextPdu_vec)obs;
        if (!this.pdu.isTimedOut()) {
            if (this.pdu.getErrorStatus() == 0) {
                varbind[] var = (varbind[])ov;
                if (var[0].getOid().toString().startsWith(dlgR4DeviceIndex)) {
                    int index = ((AsnInteger)var[0].getValue()).getValue();
                    this.deviceName = ((AsnOctets)var[1].getValue()).getValue();
                    this.deviceType = ((AsnInteger)var[2].getValue()).getValue();
                    this.openCount = ((AsnInteger)var[3].getValue()).getValue();
                    this.channelStatus = ((AsnInteger)var[4].getValue()).getValue();
                    if (this.deviceType == 2) {
                        Integer indexInt = new Integer(index);
                        if (this.openCount == 0) {
                            this.channelIndexStatusHash.remove(indexInt);
                            this.channelHash.remove(indexInt);
                        } else {
                            this.channelIndexStatusHash.put(indexInt, new Integer(this.channelStatus));
                            ChannelStatus cStatus = (ChannelStatus)this.channelHash.get(indexInt);
                            if (cStatus == null) {
                                cStatus = new ChannelStatus(index, this.channelStatus, this.deviceName, this);
                                this.channelHash.put(indexInt, cStatus);
                            } else {
                                cStatus.setStatus(this.channelStatus);
                            }
                        }
                    }
                    this.pdu = new GetNextPdu_vec(this.context, 5);
                    this.pdu.addObserver(this);
                    this.pdu.addOid(var[0].getOid().toString());
                    this.pdu.addOid(var[1].getOid().toString());
                    this.pdu.addOid(var[2].getOid().toString());
                    this.pdu.addOid(var[3].getOid().toString());
                    this.pdu.addOid(var[4].getOid().toString());
                    try {
                        this.pdu.send();
                    }
                    catch (PduException exc) {
                        System.out.println("PduException " + exc.getMessage());
                    }
                    catch (IOException exc) {
                        System.out.println("IOException " + exc.getMessage());
                    }
                } else {
                    hasEnded = true;
                }
            } else {
                hasEnded = true;
            }
        } else {
            this.channelIndexStatusHash.clear();
            this.channelHash.clear();
            hasEnded = true;
        }
        if (hasEnded) {
            this.lastUpdateDate = new Date();
            SwingUtilities.invokeLater(new TreeUpdate());
            this.isGetNextInFlight = false;
        }
    }

    public void setParent(TreeNode p) {
        this.parent = p;
    }

    public void setDefaultTreeModel(DefaultTreeModel model) {
        this.treeModel = model;
    }

    protected void fireTreeModelChanged() {
        if (this.treeModel != null) {
            this.treeModel.nodeStructureChanged(this);
        }
    }

    class TreeUpdate
    implements Runnable {
        TreeUpdate() {
        }

        public void run() {
            DialogChannelStatusBean.this.fireTreeModelChanged();
            DialogChannelStatusBean.this.firePropertyChange("modems", null, null);
        }
    }

    class ChannelStatus
    implements TreeNode {
        private TreeNode parent;
        private int index;
        private int status;
        private String name;

        public ChannelStatus(int ind, int st, String nm, TreeNode par) {
            this.index = ind;
            this.status = st;
            this.name = nm;
            this.parent = par;
        }

        public int getIndex() {
            return this.index;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int st) {
            this.status = st;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "" + this.index + " " + this.name + " " + vch_status[this.status];
        }

        public Enumeration children() {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        public int getIndex(TreeNode node) {
            return -1;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return true;
        }
    }
}

