/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class AscendActiveSessionBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: AscendActiveSessionBean.java,v 1.10 2002/10/22 16:34:23 birgit Exp $ Copyright Westhawk Ltd";
    public static final String ssnActiveCallReferenceNum = "1.3.6.1.4.1.529.12.3.1.1";
    public static final String ssnActiveUserName = "1.3.6.1.4.1.529.12.3.1.4";
    public static final String ssnActiveUserIPAddress = "1.3.6.1.4.1.529.12.3.1.5";
    public static final String ssnActiveUserSubnetMask = "1.3.6.1.4.1.529.12.3.1.6";
    public static final String ssnActiveCurrentService = "1.3.6.1.4.1.529.12.3.1.7";
    private static final int NR_OID = 5;
    private static final int none = 1;
    private static final int other = 2;
    private static final int ppp = 3;
    private static final int slip = 4;
    private static final int mpp = 5;
    private static final int x25 = 6;
    private static final int combinet = 7;
    private static final int frameRelay = 8;
    private static final int euraw = 9;
    private static final int euui = 10;
    private static final int telnet = 11;
    private static final int telnetBinary = 12;
    private static final int rawTcp = 13;
    private static final int terminalServer = 14;
    private static final int mp = 15;
    private static final int virtualConnect = 16;
    private static final int dchannelX25 = 17;
    private static final int dtpt = 18;
    private static final String[] msg_service = new String[]{"", "none", "other", "ppp", "slip", "mpp", "x25", "combinet", "frameRelay", "euraw", "euui", "telnet", "telnetBinary", "rawTcp", "terminalServer", "mp", "virtualConnect", "dchannelX25", "dtpt"};
    private GetNextPdu_vec pdu;
    private boolean isGetNextInFlight;
    private Date lastUpdateDate = null;
    private int callReferenceNum = 0;
    private String userName = "";
    private String userIPAddress = "0.0.0.0";
    private String userSubnetMask = "0.0.0.0";
    private String currentService = "none";

    public AscendActiveSessionBean() {
    }

    public AscendActiveSessionBean(String h, int p) {
        this();
        this.setHost(h);
        this.setPort(p);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserIPAddress() {
        return this.userIPAddress;
    }

    public String getUserSubnetMask() {
        return this.userSubnetMask;
    }

    public String getCurrentService() {
        return this.currentService;
    }

    public void action() {
        if (this.isHostPortReachable()) {
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.setRunning(true);
        }
    }

    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isGetNextInFlight) {
                this.isGetNextInFlight = true;
                this.pdu = new GetNextPdu_vec(this.context, 5);
                this.pdu.addObserver(this);
                this.pdu.addOid(ssnActiveCallReferenceNum);
                this.pdu.addOid(ssnActiveUserName);
                this.pdu.addOid(ssnActiveUserIPAddress);
                this.pdu.addOid(ssnActiveUserSubnetMask);
                this.pdu.addOid(ssnActiveCurrentService);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(Observable obs, Object ov) {
        this.pdu = (GetNextPdu_vec)obs;
        if (this.pdu.getErrorStatus() == 0) {
            varbind[] var = (varbind[])ov;
            this.callReferenceNum = ((AsnInteger)var[0].getValue()).getValue();
            if (this.callReferenceNum > 0) {
                this.userName = ((AsnOctets)var[1].getValue()).getValue();
                this.userIPAddress = ((AsnOctets)var[2].getValue()).getValue();
                this.userSubnetMask = ((AsnOctets)var[3].getValue()).getValue();
                int service = ((AsnInteger)var[4].getValue()).getValue();
                this.currentService = msg_service[service];
            }
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.firePropertyChange("services", null, null);
        }
    }
}

