/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.string;

import java.util.Formatter;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;

public final class StringFormat
implements Supplier<String> {
    private static final Logger LOGGER = Logger.getLogger(StringFormat.class.getName());
    private final Object[] args;
    private final String format;

    public StringFormat(String format, Object ... args) {
        this.format = format;
        this.args = args;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String get() {
        if (Utility.isBlank(this.format)) return this.format;
        if (this.args == null) return this.format;
        if (this.args.length == 0) {
            return this.format;
        }
        try (Formatter formatter = new Formatter();){
            String string = formatter.format(this.format, this.args).toString();
            return string;
        }
        catch (Throwable e) {
            LOGGER.log(Level.FINEST, String.format("Error logging message <%s>", this.format));
            return "";
        }
    }

    public String toString() {
        return this.get();
    }
}

