/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.JavaSqlTypeGroup;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public final class MetaDataUtility {
    public static Collection<List<String>> allIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, false);
    }

    public static List<String> columnNames(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column indexColumn : index) {
            columnNames.add(indexColumn.getFullName());
        }
        return columnNames;
    }

    public static ForeignKeyCardinality findForeignKeyCardinality(TableReference tableRef) {
        if (tableRef == null) {
            return ForeignKeyCardinality.unknown;
        }
        boolean isForeignKeyUnique = MetaDataUtility.isForeignKeyUnique(tableRef);
        boolean isColumnReference = tableRef.getReferencingTable() instanceof PartialDatabaseObject;
        ForeignKeyCardinality connectivity = isColumnReference ? ForeignKeyCardinality.unknown : (isForeignKeyUnique ? ForeignKeyCardinality.zero_one : ForeignKeyCardinality.zero_many);
        return connectivity;
    }

    public static List<String> foreignKeyColumnNames(TableReference tableRef) {
        if (tableRef == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnReference columnReference : tableRef) {
            columnNames.add(columnReference.getForeignKeyColumn().getFullName());
        }
        return columnNames;
    }

    public static String getColumnsListAsString(Index index, Identifiers identifiers) {
        Objects.requireNonNull(index, "No index provided");
        Objects.requireNonNull(identifiers, "No identifier quoting strategy provided");
        List<IndexColumn> columns = index.getColumns();
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    public static String getColumnsListAsString(Table table, Identifiers identifiers) {
        Objects.requireNonNull(table, "No table provided");
        Objects.requireNonNull(identifiers, "No identifier quoting strategy provided");
        List<Column> columns = table.getColumns();
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    public static String getColumnsListAsString(TableConstraint tableConstraint, Identifiers identifiers) {
        Objects.requireNonNull(tableConstraint, "No table constraint provided");
        Objects.requireNonNull(identifiers, "No identifier quoting strategy provided");
        List<TableConstraintColumn> columns = tableConstraint.getConstrainedColumns();
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    public static String getColumnsListAsString(TableReference fk, TableRelationshipType relationshipType, Identifiers identifiers) {
        Objects.requireNonNull(fk, "No foreign key provided");
        Objects.requireNonNull(identifiers, "No identifier quoting strategy provided");
        if (relationshipType == null || relationshipType == TableRelationshipType.none) {
            return "";
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (ColumnReference columnReference : fk.getColumnReferences()) {
            switch (relationshipType) {
                case parent: {
                    columns.add(columnReference.getPrimaryKeyColumn());
                    break;
                }
                case child: {
                    columns.add(columnReference.getForeignKeyColumn());
                    break;
                }
            }
        }
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    public static boolean isForeignKeyUnique(TableReference tableRef) {
        if (tableRef == null) {
            return false;
        }
        Table fkTable = tableRef.getForeignKeyTable();
        Collection<List<String>> uniqueIndexCoumnNames = MetaDataUtility.uniqueIndexCoumnNames(fkTable);
        List<String> foreignKeyColumnNames = MetaDataUtility.foreignKeyColumnNames(tableRef);
        return uniqueIndexCoumnNames.contains(foreignKeyColumnNames);
    }

    public static String joinColumns(List<? extends Column> columns, boolean omitLargeObjectColumns, Identifiers identifiers) {
        Objects.requireNonNull(columns, "No columns provided");
        Objects.requireNonNull(identifiers, "No identifiers provided");
        ArrayList<String> columnsList = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (!column.isColumnDataTypeKnown()) continue;
            JavaSqlTypeGroup javaSqlTypeGroup = column.getColumnDataType().getJavaSqlType().getJavaSqlTypeGroup();
            if (omitLargeObjectColumns && (javaSqlTypeGroup == JavaSqlTypeGroup.large_object || javaSqlTypeGroup == JavaSqlTypeGroup.object)) continue;
            columnsList.add(identifiers.quoteName(column.getName()));
        }
        return String.join((CharSequence)", ", columnsList);
    }

    public static void reduceCatalog(Catalog catalog, SchemaCrawlerOptions schemaCrawlerOptions) {
        Objects.requireNonNull(catalog, "No catalog provided");
        Objects.requireNonNull(schemaCrawlerOptions, "No SchemaCrawler options provided");
        catalog.undo(Schema.class, ReducerFactory.getSchemaReducer(schemaCrawlerOptions));
        catalog.reduce(Schema.class, ReducerFactory.getSchemaReducer(schemaCrawlerOptions));
        catalog.undo(Table.class, ReducerFactory.getTableReducer(schemaCrawlerOptions));
        catalog.reduce(Table.class, ReducerFactory.getTableReducer(schemaCrawlerOptions));
        catalog.undo(Routine.class, ReducerFactory.getRoutineReducer(schemaCrawlerOptions));
        catalog.reduce(Routine.class, ReducerFactory.getRoutineReducer(schemaCrawlerOptions));
        catalog.undo(Synonym.class, ReducerFactory.getSynonymReducer(schemaCrawlerOptions));
        catalog.reduce(Synonym.class, ReducerFactory.getSynonymReducer(schemaCrawlerOptions));
        catalog.undo(Sequence.class, ReducerFactory.getSequenceReducer(schemaCrawlerOptions));
        catalog.reduce(Sequence.class, ReducerFactory.getSequenceReducer(schemaCrawlerOptions));
    }

    public static Collection<List<String>> uniqueIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, true);
    }

    private static Collection<List<String>> indexCoumnNames(Table table, boolean includeUniqueOnly) {
        ArrayList<List<String>> allIndexCoumns = new ArrayList<List<String>>();
        if (table instanceof PartialDatabaseObject) {
            return allIndexCoumns;
        }
        for (Index index : table.getIndexes()) {
            if (includeUniqueOnly && !index.isUnique()) continue;
            List<String> indexColumns = MetaDataUtility.columnNames(index);
            allIndexCoumns.add(indexColumns);
        }
        return allIndexCoumns;
    }

    private MetaDataUtility() {
    }

    public static enum ForeignKeyCardinality {
        unknown(""),
        zero_one("(0..1)"),
        zero_many("(0..many)"),
        one_one("(1..1)");

        private final String description;

        private ForeignKeyCardinality(String description) {
            this.description = Objects.requireNonNull(description, "No description provided");
        }

        public String toString() {
            return this.description;
        }
    }
}

