/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.ImmutableColumnReference;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.RetrieverUtility;
import schemacrawler.crawl.TablePartial;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.WrappedSQLException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class ForeignKeyRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(ForeignKeyRetriever.class.getName());

    ForeignKeyRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        super(retrieverConnection, catalog, options);
    }

    void retrieveForeignKeys(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving foreign keys, using fast data dictionary retrieval");
                this.retrieveForeignKeysFromDataDictionary();
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving foreign keys");
                this.retrieveForeignKeysFromMetadata(allTables);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving foreign keys");
            }
        }
    }

    private void createForeignKeys(MetadataResultSet results, Map<NamedObjectKey, MutableForeignKey> foreignKeys) throws SQLException {
        while (results.next()) {
            MutableForeignKey foreignKey;
            String foreignKeyName = results.getString("FK_NAME");
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Retrieving foreign key: %s", new Object[]{foreignKeyName}));
            String pkTableCatalogName = this.normalizeCatalogName(results.getString("PKTABLE_CAT"));
            String pkTableSchemaName = this.normalizeSchemaName(results.getString("PKTABLE_SCHEM"));
            String pkTableName = results.getString("PKTABLE_NAME");
            String pkColumnName = results.getString("PKCOLUMN_NAME");
            String fkTableCatalogName = this.normalizeCatalogName(results.getString("FKTABLE_CAT"));
            String fkTableSchemaName = this.normalizeSchemaName(results.getString("FKTABLE_SCHEM"));
            String fkTableName = results.getString("FKTABLE_NAME");
            String fkColumnName = results.getString("FKCOLUMN_NAME");
            Optional<MutableTable> pkTableOptional = this.lookupTable(pkTableCatalogName, pkTableSchemaName, pkTableName);
            Optional<MutableTable> fkTableOptional = this.lookupTable(fkTableCatalogName, fkTableSchemaName, fkTableName);
            if (!pkTableOptional.isPresent() && !fkTableOptional.isPresent()) continue;
            int keySequence = results.getInt("KEY_SEQ", 0);
            ForeignKeyUpdateRule updateRule = results.getEnumFromId("UPDATE_RULE", ForeignKeyUpdateRule.unknown);
            ForeignKeyUpdateRule deleteRule = results.getEnumFromId("DELETE_RULE", ForeignKeyUpdateRule.unknown);
            ForeignKeyDeferrability deferrability = results.getEnumFromId("DEFERRABILITY", ForeignKeyDeferrability.unknown);
            Column pkColumn = this.lookupOrCreateColumn(pkTableCatalogName, pkTableSchemaName, pkTableName, pkColumnName);
            Column fkColumn = this.lookupOrCreateColumn(fkTableCatalogName, fkTableSchemaName, fkTableName, fkColumnName);
            boolean isPkColumnPartial = pkColumn instanceof ColumnPartial;
            boolean isFkColumnPartial = fkColumn instanceof ColumnPartial;
            if (pkColumn == null || fkColumn == null || isFkColumnPartial && isPkColumnPartial) continue;
            Table fkTable = (Table)fkColumn.getParent();
            Table pkTable = (Table)pkColumn.getParent();
            if (Utility.isBlank((CharSequence)foreignKeyName)) {
                foreignKeyName = RetrieverUtility.constructForeignKeyName(fkTable, pkTable);
                LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Identifying foreign key with blank name: %s from %s --> %s", new Object[]{foreignKeyName, fkTable, pkTable}));
            }
            NamedObjectKey fkLookupKey = new NamedObjectKey(fkTableCatalogName, fkTableSchemaName, fkTableName, foreignKeyName);
            ImmutableColumnReference columnReference = new ImmutableColumnReference(keySequence, fkColumn, pkColumn);
            Optional<MutableForeignKey> foreignKeyOptional = Optional.ofNullable(foreignKeys.get(fkLookupKey));
            if (foreignKeyOptional.isPresent()) {
                foreignKey = foreignKeyOptional.get();
                foreignKey.addColumnReference(columnReference);
            } else {
                foreignKey = new MutableForeignKey(foreignKeyName, columnReference);
                foreignKeys.put(fkLookupKey, foreignKey);
            }
            foreignKey.withQuoting(this.getRetrieverConnection().getIdentifiers());
            foreignKey.setUpdateRule(updateRule);
            foreignKey.setDeleteRule(deleteRule);
            foreignKey.setDeferrability(deferrability);
            foreignKey.addAttributes(results.getAttributes());
            if (fkColumn instanceof MutableColumn) {
                ((MutableColumn)fkColumn).setReferencedColumn(pkColumn);
                ((MutableTable)fkTable).addForeignKey(foreignKey);
            } else if (isFkColumnPartial) {
                ((ColumnPartial)fkColumn).setReferencedColumn(pkColumn);
                ((TablePartial)fkTable).addForeignKey(foreignKey);
            }
            if (pkColumn instanceof MutableColumn) {
                ((MutableTable)pkTable).addForeignKey(foreignKey);
                continue;
            }
            if (!isPkColumnPartial) continue;
            ((TablePartial)pkTable).addForeignKey(foreignKey);
        }
    }

    private Column lookupOrCreateColumn(String catalogName, String schemaName, String tableName, String columnName) {
        return RetrieverUtility.lookupOrCreateColumn(this.catalog, catalogName, schemaName, tableName, columnName);
    }

    private void retrieveForeignKeysFromDataDictionary() throws WrappedSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.FOREIGN_KEYS)) {
            LOGGER.log(Level.FINE, "Extended foreign keys SQL statement was not provided");
            return;
        }
        HashMap<NamedObjectKey, MutableForeignKey> foreignKeys = new HashMap<NamedObjectKey, MutableForeignKey>();
        Query fkSql = informationSchemaViews.getQuery(InformationSchemaKey.FOREIGN_KEYS);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(fkSql, statement, this.getSchemaInclusionRule());){
            this.createForeignKeys(results, foreignKeys);
        }
        catch (SQLException e) {
            throw new WrappedSQLException(String.format("Could not retrieve foreign keys from SQL:%n%s", fkSql), e);
        }
    }

    private void retrieveForeignKeysFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        try (Connection connection = this.getRetrieverConnection().getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ConcurrentHashMap<NamedObjectKey, MutableForeignKey> foreignKeys = new ConcurrentHashMap<NamedObjectKey, MutableForeignKey>();
            for (MutableTable table : allTables) {
                Throwable throwable;
                MetadataResultSet results;
                if (table instanceof View) continue;
                try {
                    results = new MetadataResultSet(metaData.getImportedKeys(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName()), "DatabaseMetaData::getImportedKeys");
                    throwable = null;
                    try {
                        this.createForeignKeys(results, foreignKeys);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (results != null) {
                            if (throwable != null) {
                                try {
                                    results.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                results.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    this.logPossiblyUnsupportedSQLFeature((Supplier<String>)new StringFormat("Could not retrieve foreign keys for table <%s>", new Object[]{table}), e);
                }
                try {
                    results = new MetadataResultSet(metaData.getExportedKeys(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName()), "DatabaseMetaData::getExportedKeys");
                    throwable = null;
                    try {
                        this.createForeignKeys(results, foreignKeys);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (results == null) continue;
                        if (throwable != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        results.close();
                    }
                }
                catch (SQLException e) {
                    this.logPossiblyUnsupportedSQLFeature((Supplier<String>)new StringFormat("Could not retrieve exported foreign keys for table <%s>", new Object[]{table}), e);
                }
            }
        }
    }
}

