/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.kernel.module;

import uk.org.retep.kernel.module.EventType;
import uk.org.retep.kernel.module.Module;

public class ModuleEvent<T> {
    private final EventType eventType;
    private final String moduleName;
    private final T data;

    public static ModuleEvent<Object> create(EventType eventType, String moduleName) {
        return ModuleEvent.create(eventType, moduleName, null);
    }

    public static ModuleEvent<Object> create(EventType eventType, Module module) {
        return ModuleEvent.create(eventType, module, null);
    }

    public static <T> ModuleEvent<T> create(EventType eventType, Module module, T data) {
        return ModuleEvent.create(eventType, module.getClass().getName(), data);
    }

    public static <T> ModuleEvent<T> create(EventType eventType, String moduleName, T data) {
        return new ModuleEvent<T>(eventType, moduleName, data);
    }

    private ModuleEvent(EventType eventType, String moduleName, T data) {
        this.eventType = eventType;
        this.moduleName = moduleName;
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getModuleName() {
        return this.moduleName;
    }
}

