/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.kernel.module;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import uk.org.retep.kernel.module.EventType;
import uk.org.retep.kernel.module.Module;
import uk.org.retep.kernel.module.ModuleEvent;

public abstract class AbstractModule
implements Module {
    private BlockingDeque<ModuleEvent<?>> eventDeque;
    private ClassLoader classLoader;
    private File homeDirectory;
    private File configDirectory;
    private File dataDirectory;
    private Date applicationStartDate;
    private List<String> arguments;
    private String applicationName;

    @Override
    public void setEventDeque(BlockingDeque<ModuleEvent<?>> eventDeque) {
        this.eventDeque = eventDeque;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    @Override
    public void setHomeDirectory(File homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    @Override
    public File getConfigDirectory() {
        return this.configDirectory;
    }

    @Override
    public void setConfigDirectory(File configDirectory) {
        this.configDirectory = configDirectory;
    }

    @Override
    public File getDataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public void setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    @Override
    public Date getApplicationStartDate() {
        return this.applicationStartDate;
    }

    @Override
    public void setApplicationStartDate(Date applicationStartDate) {
        this.applicationStartDate = applicationStartDate;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments == null ? Collections.emptyList() : this.arguments;
    }

    @Override
    public void setArguments(List<String> arguments) {
        this.arguments = arguments == null ? null : Collections.unmodifiableList(arguments);
    }

    @Override
    public final void start() throws Throwable {
        try {
            this.eventDeque.offer(ModuleEvent.create(EventType.STARTING, this));
            this.startImpl();
            this.eventDeque.offer(ModuleEvent.create(EventType.STARTED, this));
        }
        catch (Throwable t) {
            this.eventDeque.offer(ModuleEvent.create(EventType.FAILED, this, t));
            throw t;
        }
    }

    protected abstract void startImpl() throws Throwable;

    protected final <T> void sendIPC(T data) {
        this.eventDeque.offer(ModuleEvent.create(EventType.IPC, this, data));
    }

    @Override
    public <T> void handleModuleEvent(ModuleEvent<T> event) {
    }
}

