/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.kernel.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class KernelClassLoader
extends URLClassLoader {
    private static final String NAMEDCLASSLOADER = "com.tc.object.loaders.NamedClassLoader";
    private static final String CLASSPROCESSORHELPER = "com.tc.object.bytecode.hook.impl.ClassProcessorHelper";
    private static final String REGISTERGLOBALLOADER = "registerGlobalLoader";
    private final String name;

    public static KernelClassLoader create(String applicationName, String clusterName, File libDir, ClassLoader parent) throws MalformedURLException {
        ArrayList<URL> jars = new ArrayList<URL>();
        KernelClassLoader.addJarsInGroups(jars, new File(libDir, "common"));
        KernelClassLoader.addJarsInGroups(jars, new File(libDir, applicationName));
        if (jars.isEmpty()) {
            throw new IllegalArgumentException("No jars found in layout");
        }
        return new KernelClassLoader(clusterName, jars.toArray(new URL[jars.size()]), parent);
    }

    private KernelClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.name = name;
        try {
            Class<?> namedClassLoader = Class.forName(NAMEDCLASSLOADER);
            Class<?> helper = Class.forName(CLASSPROCESSORHELPER);
            Method m = helper.getMethod(REGISTERGLOBALLOADER, namedClassLoader);
            m.invoke(null, this);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String __tc_getClassLoaderName() {
        return this.name;
    }

    private static void addFilesInDir(List<URL> jars, File dir) throws MalformedURLException {
        File[] files;
        if (dir != null && dir.exists() && dir.isDirectory() && (files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.canRead() && file.getName().endsWith(".jar");
            }
        })) != null && files.length > 0) {
            for (File file : files) {
                jars.add(file.toURI().toURL());
            }
        }
    }

    private static void addJarsInGroups(List<URL> jars, File dir) throws MalformedURLException {
        File[] groups;
        if (dir != null && dir.exists() && dir.isDirectory() && (groups = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null && groups.length > 0) {
            for (File group : groups) {
                KernelClassLoader.addFilesInDir(jars, group);
            }
        }
    }
}

