/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.kernel.bootstrap;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import uk.org.retep.kernel.bootstrap.KernelClassLoader;
import uk.org.retep.kernel.module.Module;
import uk.org.retep.kernel.module.ModuleEvent;

public class Bootstrap {
    private static final Bootstrap instance = new Bootstrap();
    private ClassLoader classLoader;
    private String applicationName;
    private List<String> arguments = new ArrayList<String>();
    private Thread bootStrapThread;
    private File homeDirectory;
    private Date applicationStartDate;
    private Set<Module> modules;
    private BlockingDeque<ModuleEvent<?>> eventQueue;

    public static Bootstrap getInstance() {
        return instance;
    }

    private Bootstrap() {
    }

    public void setApplicationName(String applicationName) {
        int i;
        this.applicationName = applicationName;
        if (File.separatorChar == '\\' && (i = applicationName.lastIndexOf(92)) > -1) {
            this.applicationName = applicationName.substring(i + 1);
        }
    }

    public void addArgument(String arg) {
        this.arguments.add(arg);
    }

    public boolean isRestart() {
        return false;
    }

    public void bootstrap() {
        try {
            long startTime = System.currentTimeMillis();
            this.applicationStartDate = new Date(startTime);
            if (this.bootStrapThread != null) {
                throw new SecurityException("Only the BootStrap Thread may call this method");
            }
            this.bootStrapThread = Thread.currentThread();
            this.eventQueue = new LinkedBlockingDeque();
            this.createClassLoader();
            this.createModules();
            this.startModules();
            this.runEventQueue();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private void runEventQueue() throws InterruptedException {
        while (true) {
            ModuleEvent<?> event;
            if ((event = this.eventQueue.poll(1L, TimeUnit.SECONDS)) == null) {
                continue;
            }
            this.relayEvent(event);
        }
    }

    private void relayEvent(ModuleEvent<?> event) {
        for (Module module : this.modules) {
            try {
                module.handleModuleEvent(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private URL getJarURL(Class<?> clazz) throws MalformedURLException {
        URL classURL = clazz.getResource(clazz.getSimpleName() + ".class");
        if (classURL == null) {
            return null;
        }
        String path = classURL.toString();
        int i = path.indexOf(33);
        if (i > -1) {
            path = path.substring(0, i);
        }
        if (path.startsWith("jar:")) {
            path = path.substring(4);
        }
        return new URL(path);
    }

    private File getJarFile(Class<?> clazz) {
        try {
            URL jarURL = this.getJarURL(clazz);
            if (jarURL != null) {
                return new File(jarURL.getPath()).getAbsoluteFile();
            }
            return null;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void createClassLoader() throws MalformedURLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File binDir = this.getJarFile(this.getClass()).getParentFile();
        this.homeDirectory = binDir.getParentFile();
        if ("MacOS".equals(binDir.getName())) {
            this.homeDirectory = new File(this.homeDirectory, "Resources");
        }
        File libDir = new File(this.homeDirectory, "lib");
        String clusterName = System.getProperty("retep.cluster.name", this.applicationName);
        this.classLoader = KernelClassLoader.create(this.applicationName, clusterName, libDir, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    private void createModules() throws Exception {
        this.modules = new HashSet<Module>();
        ServiceLoader<Module> sl = ServiceLoader.load(Module.class, this.classLoader);
        for (Module module : sl) {
            this.modules.add(module);
        }
        File configDirectory = new File(this.homeDirectory, "etc");
        File data1Dir = new File(this.homeDirectory, "data");
        File data2Dir = new File(data1Dir, this.applicationName);
        File data3Dir = new File(data1Dir, "common");
        File dataDirectory = data2Dir.exists() ? data2Dir : data3Dir;
        for (Module module : this.modules) {
            module.setApplicationName(this.applicationName);
            module.setApplicationStartDate(this.applicationStartDate);
            module.setArguments(this.arguments);
            module.setClassLoader(this.classLoader);
            module.setConfigDirectory(configDirectory);
            module.setDataDirectory(dataDirectory);
            module.setEventDeque(this.eventQueue);
            module.setHomeDirectory(this.homeDirectory);
        }
    }

    private void startModules() throws Throwable {
        for (Module module : this.modules) {
            module.start();
        }
    }
}

