/*
 * Decompiled with CFR 0.152.
 */
package uk.co.szmg.grafana.stores;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import uk.co.szmg.grafana.GrafanaEndpoint;
import uk.co.szmg.grafana.stores.GrafanaEndpointParser;

public abstract class GrafanaEndpointStore {
    private Map<String, GrafanaEndpoint> endpoints;

    public void load() throws IOException {
        try (InputStream stream = this.getStream();){
            this.endpoints = stream != null ? new GrafanaEndpointParser().parse(stream) : Collections.emptyMap();
        }
    }

    public Map<String, GrafanaEndpoint> getEndpoints() {
        return this.endpoints;
    }

    protected abstract InputStream getStream() throws IOException;
}

