/*
 * Decompiled with CFR 0.152.
 */
package uk.co.szmg.grafana.stores;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import uk.co.szmg.grafana.DashboardFactory;
import uk.co.szmg.grafana.domain.Dashboard;

public class DashboardStore {
    private String rootPackage;
    private List<Dashboard> dashboards;

    public DashboardStore(String rootPackage) {
        this.rootPackage = rootPackage;
    }

    public void load() {
        ArrayList<Object> dashboards = new ArrayList<Object>();
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new String[]{this.rootPackage});
        Map factories = applicationContext.getBeansOfType(DashboardFactory.class);
        for (DashboardFactory dashboardFactory : factories.values()) {
            dashboards.addAll(dashboardFactory.create());
        }
        Map dashboardBeans = applicationContext.getBeansOfType(Dashboard.class);
        dashboards.addAll(dashboardBeans.values());
        this.dashboards = Collections.unmodifiableList(dashboards);
    }

    public Collection<String> getDuplicates() {
        HashSet<String> all = new HashSet<String>();
        HashSet<String> dupes = new HashSet<String>();
        for (Dashboard dashboard : this.dashboards) {
            String title = dashboard.getTitle();
            if (all.contains(title)) {
                dupes.add(title);
                continue;
            }
            all.add(title);
        }
        return dupes;
    }

    public Optional<String> getDuplicatesErrorMessage() {
        Collection<String> duplicates = this.getDuplicates();
        String message = null;
        if (!duplicates.isEmpty()) {
            message = String.format("%d duplicates found among dashboards:", duplicates.size());
            message = message + duplicates.stream().collect(Collectors.joining(", "));
        }
        return Optional.ofNullable(message);
    }

    public List<Dashboard> getDashboards() {
        return this.dashboards;
    }
}

