/*
 * Decompiled with CFR 0.152.
 */
package uk.co.szmg.grafana.stores;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import uk.co.szmg.grafana.domain.Dashboard;

public class DashboardFilter {
    private List<String> forceInclude;
    private List<String> includeFilters;
    private List<String> excludeFilters;

    public DashboardFilter(List<String> forceInclude, List<String> includeFilters, List<String> excludeFilters) {
        this.forceInclude = forceInclude;
        this.includeFilters = includeFilters;
        this.excludeFilters = excludeFilters;
    }

    public List<Dashboard> filter(List<Dashboard> dashboards) {
        LinkedHashSet<Dashboard> result = new LinkedHashSet<Dashboard>();
        for (String includeFilter : this.includeFilters) {
            this.add(result, includeFilter, dashboards);
        }
        if (this.includeFilters.isEmpty() && !this.excludeFilters.isEmpty()) {
            result.addAll(dashboards);
        }
        for (String excludeFilter : this.excludeFilters) {
            this.remove(result, excludeFilter);
        }
        if (!this.forceInclude.isEmpty()) {
            Map dashboardIndex = dashboards.stream().collect(Collectors.toMap(Dashboard::getTitle, Function.identity()));
            for (String s : this.forceInclude) {
                Dashboard dashboard = (Dashboard)dashboardIndex.get(s);
                if (dashboard == null) {
                    throw new IncludedDashboardIsNotFound(s);
                }
                result.add(dashboard);
            }
        }
        return new ArrayList<Dashboard>(result);
    }

    private void remove(Set<Dashboard> result, String filter) {
        Pattern pattern = Pattern.compile(filter);
        Iterator<Dashboard> it = result.iterator();
        while (it.hasNext()) {
            if (!pattern.matcher(it.next().getTitle()).find()) continue;
            it.remove();
        }
    }

    private void add(Set<Dashboard> result, String filter, List<Dashboard> dashboards) {
        Pattern pattern = Pattern.compile(filter);
        for (Dashboard dashboard : dashboards) {
            if (!pattern.matcher(dashboard.getTitle()).find()) continue;
            result.add(dashboard);
        }
    }

    public static class IncludedDashboardIsNotFound
    extends IllegalArgumentException {
        private String dashboardTitle;

        public IncludedDashboardIsNotFound(String dashboardTitle) {
            super("Included dashboard cannot be found: " + dashboardTitle);
            this.dashboardTitle = dashboardTitle;
        }

        public String getDashboardTitle() {
            return this.dashboardTitle;
        }
    }
}

