/*
 * Decompiled with CFR 0.152.
 */
package uk.co.szmg.grafana.dashboard;

import uk.co.szmg.grafana.dashboard.ColorTheme;
import uk.co.szmg.grafana.dashboard.Environment;
import uk.co.szmg.grafana.domain.DomainFactories;
import uk.co.szmg.grafana.domain.Graph;
import uk.co.szmg.grafana.domain.SingleStat;
import uk.co.szmg.grafana.domain.Target;

public class BasicFactories<ENV extends Environment> {
    private ENV environment;
    private ColorTheme colorTheme;

    public BasicFactories(ENV environment, ColorTheme colorTheme) {
        this.environment = environment;
        this.colorTheme = colorTheme;
    }

    public SingleStat neutralCounter(String target) {
        return ((SingleStat)DomainFactories.newSingleStat().withSpan(Integer.valueOf(2))).addTarget(this.resolveTarget(target)).withDatasource(this.getEnvironment().getDatasource());
    }

    public SingleStat counter(String target, boolean important) {
        return this.neutralCounter(target).withColors(this.getColorTheme().colorsWhenHighIsHealthy()).withColorBackground(Boolean.valueOf(important)).withColorValue(Boolean.valueOf(!important));
    }

    public SingleStat errorCounter(String target, boolean important) {
        return this.counter(target, important).withColors(this.getColorTheme().colorsWhenLowIsHealthy());
    }

    public Graph simpleGraph(String ... targets) {
        Graph graph = DomainFactories.newGraph().withDatasource(this.getEnvironment().getDatasource());
        char ref = 'A';
        for (String target : targets) {
            graph.addTarget(this.resolveTarget(target).withRefId(String.valueOf(ref)));
            ref = (char)(ref + '\u0001');
        }
        return graph;
    }

    protected Target resolveTarget(String target) {
        return DomainFactories.newTarget().withTarget(target.replaceAll("\\{ROOT}", this.getEnvironment().getMetricsRoot()));
    }

    public ENV getEnvironment() {
        return this.environment;
    }

    public ColorTheme getColorTheme() {
        return this.colorTheme;
    }
}

