/*
 * Decompiled with CFR 0.152.
 */
package uk.co.szmg.grafana;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import uk.co.szmg.grafana.GrafanaEndpoint;

public class GrafanaClient {
    private static final String USER_AGENT = "NaiveGrafanaClient";
    private static final String API_DASHBOARDS_PATH = "api/dashboards/db";
    private GrafanaEndpoint endpoint;

    public GrafanaClient(GrafanaEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void uploadDashboard(String dashboard, boolean overwrite) throws IOException {
        String url = this.getUrl(API_DASHBOARDS_PATH);
        String content = "{\"overwrite\": " + overwrite + ", \"dashboard\": " + dashboard + "}";
        this.postToGrafana(url, content);
    }

    protected int postToGrafana(String url, String content) throws IOException {
        String response;
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        if (this.endpoint.isSkipSSLValidation() && conn instanceof HttpsURLConnection) {
            this.disableSslCertValidation((HttpsURLConnection)conn);
        }
        conn.setRequestMethod("POST");
        conn.setRequestProperty("User-Agent", USER_AGENT);
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", "application/json");
        this.addAuth(conn);
        conn.setDoOutput(true);
        try (OutputStream stream = conn.getOutputStream();){
            stream.write(content.getBytes());
            stream.flush();
        }
        int responseCode = conn.getResponseCode();
        if (responseCode / 100 == 2) {
            return responseCode;
        }
        try {
            response = this.readResponse(conn);
        }
        catch (IOException ex) {
            response = "Cannot read response; " + ex.getMessage();
        }
        throw new UnexpectedGrafanaResponseException(String.format("Unexpected response from [%s]; responseCode: [%d]; response: [%s]", url, responseCode, response), responseCode, response);
    }

    protected void addAuth(HttpURLConnection conn) {
        if (this.endpoint.getApiKey() != null) {
            conn.setRequestProperty("Authorization", "Bearer " + this.endpoint.getApiKey());
        } else if (this.endpoint.getSessionCookie() != null) {
            conn.setRequestProperty("Cookie", "grafana_sess=" + this.endpoint.getSessionCookie());
        }
    }

    protected String getUrl(String path) {
        String url = this.endpoint.getBaseUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + path;
        return url;
    }

    private void disableSslCertValidation(HttpsURLConnection conn) {
        conn.setSSLSocketFactory(SslCertValidationSkipper.noCheckSslContext.getSocketFactory());
        conn.setHostnameVerifier(SslCertValidationSkipper.allValidHostname);
    }

    private String readResponse(HttpURLConnection conn) throws IOException {
        StringBuffer response = new StringBuffer();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        }
        return response.toString();
    }

    private static class SslCertValidationSkipper {
        private static SSLContext noCheckSslContext;
        private static HostnameVerifier allValidHostname;

        private SslCertValidationSkipper() {
        }

        static {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                noCheckSslContext = SSLContext.getInstance("SSL");
                noCheckSslContext.init(null, trustAllCerts, new SecureRandom());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Cannot skip SSL cert validation", e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException("Cannot skip SSL cert validation", e);
            }
            allValidHostname = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
        }
    }

    public static class UnexpectedGrafanaResponseException
    extends IllegalStateException {
        private int responseCode;
        private String response;

        public UnexpectedGrafanaResponseException(String msg, int responseCode, String response) {
            super(msg);
            this.responseCode = responseCode;
            this.response = response;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponse() {
            return this.response;
        }
    }
}

