/*
 * Decompiled with CFR 0.152.
 */
package uk.co.szmg.grafana;

import java.io.IOException;
import uk.co.szmg.grafana.DashboardSerializer;
import uk.co.szmg.grafana.GrafanaClient;
import uk.co.szmg.grafana.GrafanaEndpoint;
import uk.co.szmg.grafana.domain.Dashboard;

public class DashboardUploader {
    private GrafanaClient client;
    private DashboardSerializer dashboardSerializer;

    public DashboardUploader(GrafanaEndpoint endpoint) {
        this.client = new GrafanaClient(endpoint);
        this.dashboardSerializer = new DashboardSerializer();
    }

    public void upload(Dashboard dashboard, boolean overwrite) {
        if (dashboard.getTitle() == null) {
            throw new IllegalArgumentException("Dashboard must have a title.");
        }
        String dashboardJson = this.dashboardSerializer.toString(dashboard);
        try {
            this.client.uploadDashboard(dashboardJson, overwrite);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error happened during uploading [%s]", dashboard.getTitle()), e);
        }
    }
}

