/*
 * Decompiled with CFR 0.152.
 */
package uk.co.szmg.grafana;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import uk.co.szmg.grafana.domain.Dashboard;

public class DashboardSerializer {
    private final ObjectMapper mapper = new ObjectMapper();

    public DashboardSerializer() {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public String toString(Dashboard dashboard) {
        try {
            return this.mapper.writeValueAsString((Object)dashboard);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("dashboard cannot be serialized to JSON.It might contain non-serializable values.", e);
        }
    }

    public void write(Dashboard dashboard, Writer writer) throws IOException {
        try {
            this.mapper.writeValue(writer, (Object)dashboard);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("dashboard cannot be serialized to JSON.It might contain non-serializable values.", e);
        }
    }

    public void write(Dashboard dashboard, OutputStream stream) throws IOException {
        try {
            this.mapper.writeValue(stream, (Object)dashboard);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("dashboard cannot be serialized to JSON.It might contain non-serializable values.", e);
        }
    }
}

