/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

class ReassignDbStereo {
    ReassignDbStereo() {
    }

    static void assign(Graph g) {
        if (g.getFlags(8) == 0) {
            return;
        }
        HashMap<Integer, DbStereo> dbMap = new HashMap<Integer, DbStereo>();
        ArrayList<DbStereo> dbList = new ArrayList<DbStereo>();
        for (int v = 0; v < g.order(); ++v) {
            int d = g.degree(v);
            if (g.bondedValence(v) - d != 1) continue;
            for (int j = 0; j < d; ++j) {
                Edge edge = g.edgeAt(v, j);
                if (edge.bond().order() != 2 || edge.other(v) <= v || g.degree(v) <= 1 || g.degree(edge.other(v)) <= 1) continue;
                DbStereo dbStereo = DbStereo.create(g, edge);
                if (ReassignDbStereo.inSmallRing(g, edge)) {
                    dbStereo.config = Config.Undefined;
                }
                dbMap.put(dbStereo.u, dbStereo);
                dbMap.put(dbStereo.v, dbStereo);
                dbList.add(dbStereo);
            }
        }
        for (DbStereo dbStereo : dbList) {
            for (Edge e : dbStereo.uEdges) {
                e.bond(Bond.IMPLICIT);
            }
            for (Edge f : dbStereo.vEdges) {
                f.bond(Bond.IMPLICIT);
            }
        }
        Collections.sort(dbList, new Comparator<DbStereo>(){

            @Override
            public int compare(DbStereo a, DbStereo b) {
                int cmp = a.u - b.u;
                if (cmp != 0) {
                    return cmp;
                }
                return a.v - b.v;
            }
        });
        for (DbStereo dbStereo : dbList) {
            if (dbStereo.mark || dbStereo.config == Config.Undefined || !ReassignDbStereo.setConfig(g, dbStereo, dbMap)) continue;
            System.err.println("Warning - Double-bond stereo assignment");
        }
    }

    static boolean inSmallRing(Graph g, Edge e) {
        return ReassignDbStereo.inSmallRing(g, e.either(), e.other(e.either()), e.other(e.either()), 1, new BitSet());
    }

    static boolean inSmallRing(Graph g, int v, int prev, int t, int d, BitSet visit) {
        if (d > 7) {
            return false;
        }
        if (v == t) {
            return true;
        }
        if (visit.get(v)) {
            return false;
        }
        visit.set(v);
        int deg = g.degree(v);
        for (int j = 0; j < deg; ++j) {
            Edge e = g.edgeAt(v, j);
            int w = e.other(v);
            if (w == prev || !ReassignDbStereo.inSmallRing(g, w, v, t, d + 1, visit)) continue;
            return true;
        }
        visit.clear(v);
        return false;
    }

    static void setFirstConfig(DbStereo dbStereo) {
        Bond fst;
        Bond snd = fst = Bond.DOWN;
        if (dbStereo.config == Config.Opposite) {
            snd = snd.inverse();
        }
        dbStereo.uEdges[0].bond(dbStereo.uEdges[0].either() == dbStereo.u ? fst : fst.inverse());
        dbStereo.vEdges[0].bond(dbStereo.vEdges[0].either() == dbStereo.v ? snd : snd.inverse());
        dbStereo.mark = true;
    }

    static boolean setConfig(Graph g, DbStereo dbStereo, Map<Integer, DbStereo> dbStereoMap) {
        Edge e;
        int j;
        if (dbStereo.mark || dbStereo.config == Config.Undefined) {
            return false;
        }
        Bond left = DbStereo.dirOfFirst(dbStereo.uEdges, dbStereo.u);
        Bond right = DbStereo.dirOfFirst(dbStereo.vEdges, dbStereo.v);
        if (!left.directional() && !right.directional()) {
            left = Bond.DOWN;
            right = dbStereo.config == Config.Opposite ? left.inverse() : left;
            dbStereo.uEdges[0].bond(dbStereo.uEdges[0].either() == dbStereo.u ? left : left.inverse());
            dbStereo.vEdges[0].bond(dbStereo.vEdges[0].either() == dbStereo.v ? right : right.inverse());
        } else if (!left.directional()) {
            left = dbStereo.config == Config.Opposite ? right.inverse() : right;
            dbStereo.uEdges[0].bond(dbStereo.uEdges[0].either() == dbStereo.u ? left : left.inverse());
        } else if (!right.directional()) {
            right = dbStereo.config == Config.Opposite ? left.inverse() : left;
            dbStereo.vEdges[0].bond(dbStereo.vEdges[0].either() == dbStereo.v ? right : right.inverse());
        } else if (dbStereo.config == Config.Together && left != right) {
            return true;
        }
        dbStereo.mark = true;
        boolean res = false;
        int d = g.degree(dbStereo.u);
        for (j = 0; j < d; ++j) {
            e = g.edgeAt(dbStereo.u, j);
            if (!dbStereoMap.containsKey(e.other(dbStereo.u))) continue;
            res = ReassignDbStereo.setConfig(g, dbStereoMap.get(e.other(dbStereo.u)), dbStereoMap) || res;
        }
        d = g.degree(dbStereo.v);
        for (j = 0; j < d; ++j) {
            e = g.edgeAt(dbStereo.v, j);
            if (!dbStereoMap.containsKey(e.other(dbStereo.v))) continue;
            res = ReassignDbStereo.setConfig(g, dbStereoMap.get(e.other(dbStereo.v)), dbStereoMap) || res;
        }
        return res;
    }

    static Config config(Graph g, Edge e) {
        int u = e.either();
        int v = e.other(u);
        Bond ub = ReassignDbStereo.firstBond(g, u);
        Bond vb = ReassignDbStereo.firstBond(g, v);
        if (ub == Bond.IMPLICIT || vb == Bond.IMPLICIT) {
            return Config.Undefined;
        }
        return ub == vb ? Config.Together : Config.Opposite;
    }

    static Bond firstBond(Graph g, int v) {
        int d = g.degree(v);
        boolean seenimplied = false;
        for (int j = 0; j < d; ++j) {
            Edge e = g.edgeAt(v, j);
            if (e.bond().directional()) {
                return seenimplied ? e.bond(v).inverse() : e.bond(v);
            }
            if (e.bond().order() != 1) continue;
            seenimplied = true;
        }
        return Bond.IMPLICIT;
    }

    private static final class DbStereo {
        Edge[] uEdges;
        Edge[] vEdges;
        int u;
        int v;
        Config config;
        boolean mark;

        private DbStereo(int u, int v, Edge[] uEdges, Edge[] vEdges) {
            this.u = u;
            this.v = v;
            this.uEdges = uEdges;
            this.vEdges = vEdges;
            Bond fst = DbStereo.dirOfFirst(uEdges, u);
            Bond snd = DbStereo.dirOfFirst(vEdges, v);
            this.config = !fst.directional() && snd.directional() ? Config.Undefined : (fst == snd ? Config.Together : Config.Opposite);
        }

        private static Bond dirOfFirst(Edge[] e, int u) {
            if (e.length == 1) {
                return e[0].bond(u);
            }
            if (e[0].bond().directional()) {
                return e[0].bond(u);
            }
            return e[1].bond(u).inverse();
        }

        private static DbStereo create(Graph g, Edge e) {
            int v;
            assert (e.bond().order() == 2);
            int u = e.either();
            if (u > (v = e.other(u))) {
                u = v;
                v = e.either();
            }
            Edge[] uEdges = new Edge[g.degree(u) - 1];
            Edge[] vEdges = new Edge[g.degree(v) - 1];
            int i = 0;
            for (Edge f : g.edges(u)) {
                if (f == e) continue;
                uEdges[i++] = f;
            }
            i = 0;
            for (Edge f : g.edges(v)) {
                if (f == e) continue;
                vEdges[i++] = f;
            }
            return new DbStereo(u, v, uEdges, vEdges);
        }

        public String toString() {
            return this.u + "=" + this.v + ": " + (Object)((Object)this.config);
        }
    }

    static enum Config {
        Together,
        Opposite,
        Undefined;

    }
}

