/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.impl.TypeIdResolverBase;

public class SimpleNameIdResolver
extends TypeIdResolverBase
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final ConcurrentHashMap<String, String> _typeToId;
    protected final Map<String, JavaType> _idToType;
    protected final boolean _caseInsensitive;

    protected SimpleNameIdResolver(JavaType baseType, ConcurrentHashMap<String, String> typeToId, HashMap<String, JavaType> idToType, boolean caseInsensitive) {
        super(baseType);
        this._typeToId = typeToId;
        this._idToType = idToType;
        this._caseInsensitive = caseInsensitive;
    }

    public static SimpleNameIdResolver construct(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        HashMap<String, JavaType> idToType;
        ConcurrentHashMap<String, String> typeToId;
        if (forSer == forDeser) {
            throw new IllegalArgumentException();
        }
        if (forSer) {
            typeToId = new ConcurrentHashMap<String, String>();
            idToType = null;
        } else {
            idToType = new HashMap<String, JavaType>();
            typeToId = new ConcurrentHashMap(4);
        }
        boolean caseInsensitive = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
        if (subtypes != null) {
            for (NamedType t : subtypes) {
                JavaType prev;
                String id;
                Class<?> cls = t.getType();
                String string = id = t.hasName() ? t.getName() : SimpleNameIdResolver._defaultTypeId(cls);
                if (forSer) {
                    typeToId.put(cls.getName(), id);
                }
                if (!forDeser) continue;
                if (caseInsensitive) {
                    id = id.toLowerCase();
                }
                if ((prev = idToType.get(id)) != null && cls.isAssignableFrom(prev.getRawClass())) continue;
                idToType.put(id, config.constructType(cls));
            }
        }
        return new SimpleNameIdResolver(baseType, typeToId, idToType, caseInsensitive);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.SIMPLE_NAME;
    }

    @Override
    public String idFromValue(DatabindContext ctxt, Object value) {
        return this.idFromClass(ctxt, value.getClass());
    }

    protected String idFromClass(DatabindContext ctxt, Class<?> cls) {
        if (cls == null) {
            return null;
        }
        String key = (cls = this._resolveToParentAsNecessary(cls)).getName();
        String name = this._typeToId.get(key);
        if (name == null) {
            if (ctxt.isAnnotationProcessingEnabled()) {
                name = ctxt.getAnnotationIntrospector().findTypeName(ctxt.getConfig(), ctxt.introspectClassAnnotations(cls));
            }
            if (name == null) {
                name = SimpleNameIdResolver._defaultTypeId(cls);
            }
            this._typeToId.put(key, name);
        }
        return name;
    }

    @Override
    public String idFromValueAndType(DatabindContext ctxt, Object value, Class<?> type) {
        if (value == null) {
            return this.idFromClass(ctxt, type);
        }
        return this.idFromValue(ctxt, value);
    }

    @Override
    public JavaType typeFromId(DatabindContext ctxt, String id) {
        return this._typeFromId(id);
    }

    protected JavaType _typeFromId(String id) {
        if (this._caseInsensitive) {
            id = id.toLowerCase();
        }
        return this._idToType.get(id);
    }

    @Override
    public String getDescForKnownTypeIds() {
        TreeSet<String> ids = new TreeSet<String>();
        for (Map.Entry<String, JavaType> entry : this._idToType.entrySet()) {
            if (!entry.getValue().isConcrete()) continue;
            ids.add(entry.getKey());
        }
        return ids.toString();
    }

    protected static String _defaultTypeId(Class<?> cls) {
        String n = cls.getName();
        int ix = Math.max(n.lastIndexOf(46), n.lastIndexOf(36));
        return ix < 0 ? n : n.substring(ix + 1);
    }
}

