/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser.key;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.ext.javatime.util.DecimalUtils;

public class ZonedDateTimeKeySerializer
extends ValueSerializer<ZonedDateTime> {
    public static final ZonedDateTimeKeySerializer INSTANCE = new ZonedDateTimeKeySerializer();

    private ZonedDateTimeKeySerializer() {
    }

    @Override
    public void serialize(ZonedDateTime value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (ctxt.isEnabled(DateTimeFeature.WRITE_DATES_WITH_ZONE_ID)) {
            g.writeName(DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value));
        } else if (ZonedDateTimeKeySerializer.useTimestamps(ctxt)) {
            if (ZonedDateTimeKeySerializer.useNanos(ctxt)) {
                g.writeName(DecimalUtils.toBigDecimal(value.toEpochSecond(), value.getNano()).toString());
            } else {
                g.writeName(String.valueOf(value.toInstant().toEpochMilli()));
            }
        } else {
            g.writeName(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value));
        }
    }

    private static boolean useNanos(SerializationContext ctxt) {
        return ctxt.isEnabled(DateTimeFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    private static boolean useTimestamps(SerializationContext ctxt) {
        return ctxt.isEnabled(DateTimeFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS);
    }
}

