/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.UnaryOperator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;

public abstract class PropertySerializerMap
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final boolean _resetWhenFull;

    protected PropertySerializerMap(boolean resetWhenFull) {
        this._resetWhenFull = resetWhenFull;
    }

    protected PropertySerializerMap(PropertySerializerMap base) {
        this._resetWhenFull = base._resetWhenFull;
    }

    public abstract ValueSerializer<Object> serializerFor(Class<?> var1);

    public final SerializerAndMapResult findAndAddPrimarySerializer(JavaType type, SerializationContext provider, BeanProperty property) {
        ValueSerializer<Object> serializer = provider.findPrimaryPropertySerializer(type, property);
        return new SerializerAndMapResult(serializer, this.newWith(type.getRawClass(), serializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(Class<?> type, SerializationContext provider, BeanProperty property) {
        ValueSerializer<Object> serializer = provider.findContentValueSerializer(type, property);
        return new SerializerAndMapResult(serializer, this.newWith(type, serializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(JavaType type, SerializationContext provider, BeanProperty property) {
        ValueSerializer<Object> serializer = provider.findContentValueSerializer(type, property);
        return new SerializerAndMapResult(serializer, this.newWith(type.getRawClass(), serializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(Class<?> type, SerializationContext provider, BeanProperty property, UnaryOperator<ValueSerializer<Object>> serTransformer) {
        ValueSerializer serializer = provider.findContentValueSerializer(type, property);
        serializer = (ValueSerializer)serTransformer.apply(serializer);
        return new SerializerAndMapResult(serializer, this.newWith(type, serializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(JavaType type, SerializationContext provider, BeanProperty property, UnaryOperator<ValueSerializer<Object>> serTransformer) {
        ValueSerializer serializer = provider.findContentValueSerializer(type, property);
        serializer = (ValueSerializer)serTransformer.apply(serializer);
        return new SerializerAndMapResult(serializer, this.newWith(type.getRawClass(), serializer));
    }

    public final SerializerAndMapResult findAndAddRootValueSerializer(Class<?> type, SerializationContext provider) {
        ValueSerializer<Object> serializer = provider.findTypedValueSerializer(type, false);
        return new SerializerAndMapResult(serializer, this.newWith(type, serializer));
    }

    public final SerializerAndMapResult findAndAddRootValueSerializer(JavaType type, SerializationContext provider) {
        ValueSerializer<Object> serializer = provider.findTypedValueSerializer(type, false);
        return new SerializerAndMapResult(serializer, this.newWith(type.getRawClass(), serializer));
    }

    public final SerializerAndMapResult findAndAddKeySerializer(Class<?> type, SerializationContext provider, BeanProperty property) {
        ValueSerializer<Object> serializer = provider.findKeySerializer(type, property);
        return new SerializerAndMapResult(serializer, this.newWith(type, serializer));
    }

    public final SerializerAndMapResult addSerializer(Class<?> type, ValueSerializer<Object> serializer) {
        return new SerializerAndMapResult(serializer, this.newWith(type, serializer));
    }

    public final SerializerAndMapResult addSerializer(JavaType type, ValueSerializer<Object> serializer) {
        return new SerializerAndMapResult(serializer, this.newWith(type.getRawClass(), serializer));
    }

    public abstract PropertySerializerMap newWith(Class<?> var1, ValueSerializer<Object> var2);

    public static PropertySerializerMap emptyForProperties() {
        return Empty.FOR_PROPERTIES;
    }

    public static PropertySerializerMap emptyForRootValues() {
        return Empty.FOR_ROOT_VALUES;
    }

    public static final class SerializerAndMapResult {
        public final ValueSerializer<Object> serializer;
        public final PropertySerializerMap map;

        public SerializerAndMapResult(ValueSerializer<Object> serializer, PropertySerializerMap map) {
            this.serializer = serializer;
            this.map = map;
        }
    }

    private static final class Empty
    extends PropertySerializerMap
    implements Serializable {
        private static final long serialVersionUID = 3L;
        public static final Empty FOR_PROPERTIES = new Empty(false);
        public static final Empty FOR_ROOT_VALUES = new Empty(true);

        protected Empty(boolean resetWhenFull) {
            super(resetWhenFull);
        }

        public static Empty emptyFor(PropertySerializerMap src) {
            return src._resetWhenFull ? FOR_ROOT_VALUES : FOR_PROPERTIES;
        }

        Object readResolve() {
            return Empty.emptyFor(this);
        }

        @Override
        public ValueSerializer<Object> serializerFor(Class<?> type) {
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> type, ValueSerializer<Object> serializer) {
            return new Single(this, type, serializer);
        }
    }

    private static final class Multi
    extends PropertySerializerMap
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private static final int MAX_ENTRIES = 8;
        private final TypeAndSerializer[] _entries;

        public Multi(PropertySerializerMap base, TypeAndSerializer[] entries) {
            super(base);
            this._entries = entries;
        }

        Object writeReplace() {
            return Empty.emptyFor(this);
        }

        @Override
        public ValueSerializer<Object> serializerFor(Class<?> type) {
            TypeAndSerializer entry = this._entries[0];
            if (entry.type == type) {
                return entry.serializer;
            }
            entry = this._entries[1];
            if (entry.type == type) {
                return entry.serializer;
            }
            entry = this._entries[2];
            if (entry.type == type) {
                return entry.serializer;
            }
            switch (this._entries.length) {
                case 8: {
                    entry = this._entries[7];
                    if (entry.type == type) {
                        return entry.serializer;
                    }
                }
                case 7: {
                    entry = this._entries[6];
                    if (entry.type == type) {
                        return entry.serializer;
                    }
                }
                case 6: {
                    entry = this._entries[5];
                    if (entry.type == type) {
                        return entry.serializer;
                    }
                }
                case 5: {
                    entry = this._entries[4];
                    if (entry.type == type) {
                        return entry.serializer;
                    }
                }
                case 4: {
                    entry = this._entries[3];
                    if (entry.type != type) break;
                    return entry.serializer;
                }
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> type, ValueSerializer<Object> serializer) {
            int len = this._entries.length;
            if (len == 8) {
                if (this._resetWhenFull) {
                    return new Single(this, type, serializer);
                }
                return this;
            }
            TypeAndSerializer[] entries = Arrays.copyOf(this._entries, len + 1);
            entries[len] = new TypeAndSerializer(type, serializer);
            return new Multi(this, entries);
        }
    }

    private static final class Double
    extends PropertySerializerMap
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final Class<?> _type1;
        private final Class<?> _type2;
        private final ValueSerializer<Object> _serializer1;
        private final ValueSerializer<Object> _serializer2;

        public Double(PropertySerializerMap base, Class<?> type1, ValueSerializer<Object> serializer1, Class<?> type2, ValueSerializer<Object> serializer2) {
            super(base);
            this._type1 = type1;
            this._serializer1 = serializer1;
            this._type2 = type2;
            this._serializer2 = serializer2;
        }

        Object writeReplace() {
            return Empty.emptyFor(this);
        }

        @Override
        public ValueSerializer<Object> serializerFor(Class<?> type) {
            if (type == this._type1) {
                return this._serializer1;
            }
            if (type == this._type2) {
                return this._serializer2;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> type, ValueSerializer<Object> serializer) {
            TypeAndSerializer[] ts = new TypeAndSerializer[]{new TypeAndSerializer(this._type1, this._serializer1), new TypeAndSerializer(this._type2, this._serializer2), new TypeAndSerializer(type, serializer)};
            return new Multi(this, ts);
        }
    }

    private static final class Single
    extends PropertySerializerMap
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final Class<?> _type;
        private final ValueSerializer<Object> _serializer;

        public Single(PropertySerializerMap base, Class<?> type, ValueSerializer<Object> serializer) {
            super(base);
            this._type = type;
            this._serializer = serializer;
        }

        Object writeReplace() {
            return Empty.emptyFor(this);
        }

        @Override
        public ValueSerializer<Object> serializerFor(Class<?> type) {
            if (type == this._type) {
                return this._serializer;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> type, ValueSerializer<Object> serializer) {
            return new Double(this, this._type, this._serializer, type, serializer);
        }
    }

    private static final class TypeAndSerializer {
        public final Class<?> type;
        public final ValueSerializer<Object> serializer;

        public TypeAndSerializer(Class<?> type, ValueSerializer<Object> serializer) {
            this.type = type;
            this.serializer = serializer;
        }
    }
}

