/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.databind.util.Annotations;

public abstract class VirtualBeanPropertyWriter
extends BeanPropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected VirtualBeanPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        this(propDef, contextAnnotations, declaredType, null, null, null, propDef.findInclusion(), null);
    }

    protected VirtualBeanPropertyWriter() {
    }

    protected VirtualBeanPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, ValueSerializer<?> ser, TypeSerializer typeSer, JavaType serType, JsonInclude.Value inclusion, Class<?>[] includeInViews) {
        super(propDef, propDef.getPrimaryMember(), contextAnnotations, declaredType, ser, typeSer, serType, VirtualBeanPropertyWriter._suppressNulls(inclusion), VirtualBeanPropertyWriter._suppressableValue(inclusion), includeInViews);
    }

    protected VirtualBeanPropertyWriter(VirtualBeanPropertyWriter base) {
        super(base);
    }

    protected VirtualBeanPropertyWriter(VirtualBeanPropertyWriter base, PropertyName name) {
        super((BeanPropertyWriter)base, name);
    }

    protected static boolean _suppressNulls(JsonInclude.Value inclusion) {
        if (inclusion == null) {
            return false;
        }
        JsonInclude.Include incl = inclusion.getValueInclusion();
        return incl != JsonInclude.Include.ALWAYS && incl != JsonInclude.Include.USE_DEFAULTS;
    }

    protected static Object _suppressableValue(JsonInclude.Value inclusion) {
        if (inclusion == null) {
            return false;
        }
        JsonInclude.Include incl = inclusion.getValueInclusion();
        if (incl == JsonInclude.Include.ALWAYS || incl == JsonInclude.Include.NON_NULL || incl == JsonInclude.Include.USE_DEFAULTS) {
            return null;
        }
        return MARKER_FOR_EMPTY;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    protected abstract Object value(Object var1, JsonGenerator var2, SerializationContext var3) throws Exception;

    public abstract VirtualBeanPropertyWriter withConfig(MapperConfig<?> var1, AnnotatedClass var2, BeanPropertyDefinition var3, JavaType var4);

    @Override
    public void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap m;
        Object value = this.value(bean, g, prov);
        if (value == null) {
            if (this._nullSerializer != null) {
                g.writeName((SerializableString)this._name);
                this._nullSerializer.serialize(null, g, prov);
            }
            return;
        }
        ValueSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (m = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(m, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean && this._handleSelfReference(bean, g, prov, ser)) {
            return;
        }
        g.writeName((SerializableString)this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value, g, prov);
        } else {
            ser.serializeWithType(value, g, prov, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsElement(Object bean, JsonGenerator g, SerializationContext prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value = this.value(bean, g, prov);
        if (value == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, g, prov);
            } else {
                g.writeNull();
            }
            return;
        }
        ValueSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, prov);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (ser.isEmpty(prov, value)) {
                    this.serializeAsOmittedElement(bean, g, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsOmittedElement(bean, g, prov);
                return;
            }
        }
        if (value == bean && this._handleSelfReference(bean, g, prov, ser)) {
            return;
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, g, prov);
        } else {
            ser.serializeWithType(value, g, prov, this._typeSerializer);
        }
    }
}

