/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.util.Objects;
import java.util.Optional;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ValueNode;

public class StringNode
extends ValueNode {
    private static final long serialVersionUID = 3L;
    static final StringNode EMPTY_STRING_NODE = new StringNode("");
    protected final String _value;

    public StringNode(String v) {
        this._value = Objects.requireNonNull(v);
    }

    public static StringNode valueOf(String v) {
        if (v == null) {
            return null;
        }
        if (v.isEmpty()) {
            return EMPTY_STRING_NODE;
        }
        return new StringNode(v);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.STRING;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_STRING;
    }

    @Override
    protected String _valueDesc() {
        String s = this._value;
        if (s.length() > 100) {
            return String.format("\"%s\"[...]", s.substring(0, 100));
        }
        return "\"" + this._value + "\"";
    }

    @Override
    public StringNode deepCopy() {
        return this;
    }

    @Override
    public String stringValue() {
        return this._value;
    }

    @Override
    public String stringValue(String defaultValue) {
        return this._value;
    }

    @Override
    public Optional<String> stringValueOpt() {
        return Optional.of(this._value);
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws JacksonException {
        String str = this._value.trim();
        int initBlockSize = 4 + (str.length() >> 2) * 3;
        ByteArrayBuilder builder = new ByteArrayBuilder(Math.max(16, Math.min(65536, initBlockSize)));
        try {
            b64variant.decode(str, builder);
        }
        catch (IllegalArgumentException e) {
            return (byte[])this._reportCoercionFail("binaryValue()", byte[].class, "value type not binary and Base64-decoding failed with: " + e.getMessage());
        }
        return builder.toByteArray();
    }

    @Override
    public byte[] binaryValue() throws JacksonException {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    @Override
    public String asString() {
        return this._value;
    }

    @Override
    public String asString(String defaultValue) {
        return this._value;
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        String v = this._value.trim();
        if ("true".equals(v)) {
            return true;
        }
        if ("false".equals(v)) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public int asInt(int defaultValue) {
        return NumberInput.parseAsInt((String)this._value, (int)defaultValue);
    }

    @Override
    public long asLong(long defaultValue) {
        return NumberInput.parseAsLong((String)this._value, (long)defaultValue);
    }

    @Override
    public double asDouble(double defaultValue) {
        return NumberInput.parseAsDouble((String)this._value, (double)defaultValue, (boolean)false);
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeString(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof StringNode) {
            return Objects.equals(((StringNode)o)._value, this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }
}

