/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ValueNode;
import tools.jackson.databind.util.ClassUtil;

public class POJONode
extends ValueNode {
    private static final long serialVersionUID = 3L;
    protected final Object _value;

    public POJONode(Object v) {
        this._value = v;
    }

    @Override
    protected String _valueDesc() {
        return "{POJO of type " + ClassUtil.classNameOf(this._value) + "}";
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.POJO;
    }

    @Override
    public boolean isEmbeddedValue() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public byte[] binaryValue() {
        if (this._value instanceof byte[]) {
            return (byte[])this._value;
        }
        return super.binaryValue();
    }

    @Override
    public String asString() {
        return this._value == null ? "null" : this._value.toString();
    }

    @Override
    public String asString(String defaultValue) {
        return this._value == null ? defaultValue : this._value.toString();
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        if (this._value instanceof Boolean) {
            return (Boolean)this._value;
        }
        return defaultValue;
    }

    @Override
    public int asInt(int defaultValue) {
        if (this._value instanceof Number) {
            return ((Number)this._value).intValue();
        }
        return defaultValue;
    }

    @Override
    public long asLong(long defaultValue) {
        if (this._value instanceof Number) {
            return ((Number)this._value).longValue();
        }
        return defaultValue;
    }

    @Override
    public double asDouble(double defaultValue) {
        if (this._value instanceof Number) {
            return ((Number)this._value).doubleValue();
        }
        return defaultValue;
    }

    @Override
    public final void serialize(JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        if (this._value == null) {
            ctxt.defaultSerializeNullValue(gen);
        } else if (this._value instanceof JacksonSerializable) {
            ((JacksonSerializable)this._value).serialize(gen, ctxt);
        } else {
            ctxt.writeValue(gen, this._value);
        }
    }

    public Object getPojo() {
        return this._value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof POJONode) {
            return this._pojoEquals((POJONode)o);
        }
        return false;
    }

    protected boolean _pojoEquals(POJONode other) {
        if (this._value == null) {
            return other._value == null;
        }
        return this._value.equals(other._value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this._value);
    }
}

