/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericNode;

public class LongNode
extends NumericNode {
    private static final long serialVersionUID = 3L;
    protected final long _value;

    public LongNode(long v) {
        this._value = v;
    }

    public static LongNode valueOf(long l) {
        return new LongNode(l);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.LONG;
    }

    @Override
    public boolean isIntegralNumber() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean canConvertToInt() {
        return this._value >= Integer.MIN_VALUE && this._value <= Integer.MAX_VALUE;
    }

    @Override
    public boolean canConvertToLong() {
        return true;
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        if (this._value >= -32768L && this._value <= 32767L) {
            return (short)this._value;
        }
        return this._reportShortCoercionRangeFail("shortValue()");
    }

    @Override
    public int intValue() {
        if (this.canConvertToInt()) {
            return (int)this._value;
        }
        return this._reportIntCoercionRangeFail("intValue()");
    }

    @Override
    public int intValue(int defaultValue) {
        return this.canConvertToInt() ? (int)this._value : defaultValue;
    }

    @Override
    public OptionalInt intValueOpt() {
        return this.canConvertToInt() ? OptionalInt.of((int)this._value) : OptionalInt.empty();
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public long longValue(long defaultValue) {
        return this._value;
    }

    @Override
    public OptionalLong longValueOpt() {
        return OptionalLong.of(this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this._value);
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public double doubleValue(double defaultValue) {
        return this._value;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        return OptionalDouble.of(this._value);
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this.decimalValue();
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this.decimalValue());
    }

    @Override
    public String asString() {
        return String.valueOf(this._value);
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return this._value != 0L;
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializationContext provider) throws JacksonException {
        jg.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof LongNode) {
            return ((LongNode)o)._value == this._value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this._value ^ (int)(this._value >> 32);
    }
}

