/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericNode;

public class IntNode
extends NumericNode {
    private static final long serialVersionUID = 3L;
    static final int MIN_CANONICAL = -1;
    static final int MAX_CANONICAL = 10;
    private static final IntNode[] CANONICALS;
    protected final int _value;

    public IntNode(int v) {
        this._value = v;
    }

    public static IntNode valueOf(int i) {
        if (i > 10 || i < -1) {
            return new IntNode(i);
        }
        return CANONICALS[i - -1];
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.INT;
    }

    @Override
    public boolean isIntegralNumber() {
        return true;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean canConvertToInt() {
        return true;
    }

    @Override
    public boolean canConvertToLong() {
        return true;
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        if (this._value >= Short.MIN_VALUE && this._value <= Short.MAX_VALUE) {
            return (short)this._value;
        }
        return this._reportShortCoercionRangeFail("shortValue()");
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public int intValue(int defaultValue) {
        return this._value;
    }

    @Override
    public OptionalInt intValueOpt() {
        return OptionalInt.of(this._value);
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public long longValue(long defaultValue) {
        return this._value;
    }

    @Override
    public OptionalLong longValueOpt() {
        return OptionalLong.of(this._value);
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public double doubleValue(double defaultValue) {
        return this._value;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        return OptionalDouble.of(this._value);
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this.decimalValue();
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this.decimalValue());
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this._value);
    }

    @Override
    public String asString() {
        return String.valueOf(this._value);
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return this._value != 0;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof IntNode) {
            return ((IntNode)o)._value == this._value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value;
    }

    static {
        int count = 12;
        CANONICALS = new IntNode[count];
        for (int i = 0; i < count; ++i) {
            IntNode.CANONICALS[i] = new IntNode(-1 + i);
        }
    }
}

