/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericNode;

public class DecimalNode
extends NumericNode {
    private static final long serialVersionUID = 3L;
    public static final DecimalNode ZERO = new DecimalNode(BigDecimal.ZERO);
    private static final BigDecimal MIN_SHORT = BigDecimal.valueOf(-32768L);
    private static final BigDecimal MAX_SHORT = BigDecimal.valueOf(32767L);
    private static final BigDecimal MIN_INTEGER = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal MAX_INTEGER = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    protected final BigDecimal _value;

    public DecimalNode(BigDecimal v) {
        this._value = Objects.requireNonNull(v);
    }

    public static DecimalNode valueOf(BigDecimal d) {
        return new DecimalNode(d);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.BIG_DECIMAL;
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return true;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean canConvertToInt() {
        return this._inIntRange() && this.canConvertToExactIntegral();
    }

    @Override
    public boolean canConvertToLong() {
        return this._inLongRange() && this.canConvertToExactIntegral();
    }

    @Override
    public boolean canConvertToExactIntegral() {
        return !this._hasFractionalPart();
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        if (!this._inShortRange()) {
            return this._reportShortCoercionRangeFail("shortValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportShortCoercionFractionFail("shortValue()");
        }
        return this._value.shortValue();
    }

    @Override
    public int intValue() {
        if (!this._inIntRange()) {
            return this._reportIntCoercionRangeFail("intValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportIntCoercionFractionFail("intValue()");
        }
        return this._value.intValue();
    }

    @Override
    public int intValue(int defaultValue) {
        if (!this._inIntRange() || this._hasFractionalPart()) {
            return defaultValue;
        }
        return this._value.intValue();
    }

    @Override
    public OptionalInt intValueOpt() {
        if (!this._inIntRange() || this._hasFractionalPart()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this._value.intValue());
    }

    @Override
    public long longValue() {
        if (!this._inLongRange()) {
            return this._reportLongCoercionRangeFail("longValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportLongCoercionFractionFail("longValue()");
        }
        return this._value.longValue();
    }

    @Override
    public long longValue(long defaultValue) {
        if (!this._inLongRange() || this._hasFractionalPart()) {
            return defaultValue;
        }
        return this._value.longValue();
    }

    @Override
    public OptionalLong longValueOpt() {
        if (!this._inLongRange() || this._hasFractionalPart()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this._value.longValue());
    }

    @Override
    public BigInteger bigIntegerValue() {
        if (this._hasFractionalPart()) {
            this._reportBigIntegerCoercionFractionFail("bigIntegerValue()");
        }
        return this._value.toBigInteger();
    }

    @Override
    public float floatValue() {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatCoercionRangeFail("floatValue()");
    }

    @Override
    public double doubleValue() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return this._reportDoubleCoercionRangeFail("doubleValue()");
    }

    @Override
    public double doubleValue(double defaultValue) {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return defaultValue;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return OptionalDouble.of(this._value.doubleValue());
        }
        return OptionalDouble.empty();
    }

    @Override
    public BigDecimal decimalValue() {
        return this._value;
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this._value;
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this._value);
    }

    @Override
    public String asString() {
        return this._value.toString();
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DecimalNode) {
            DecimalNode otherNode = (DecimalNode)o;
            return otherNode._value.equals(this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }

    private boolean _hasFractionalPart() {
        return this._value.signum() != 0 && this._value.scale() > 0 && this._value.stripTrailingZeros().scale() > 0;
    }

    private boolean _inShortRange() {
        return this._value.compareTo(MIN_SHORT) >= 0 && this._value.compareTo(MAX_SHORT) <= 0;
    }

    private boolean _inIntRange() {
        return this._value.compareTo(MIN_INTEGER) >= 0 && this._value.compareTo(MAX_INTEGER) <= 0;
    }

    private boolean _inLongRange() {
        return this._value.compareTo(MIN_LONG) >= 0 && this._value.compareTo(MAX_LONG) <= 0;
    }
}

