/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericNode;

public class BigIntegerNode
extends NumericNode {
    private static final long serialVersionUID = 3L;
    private static final BigInteger MIN_INTEGER = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX_INTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected final BigInteger _value;

    public BigIntegerNode(BigInteger v) {
        this._value = Objects.requireNonNull(v);
    }

    public static BigIntegerNode valueOf(BigInteger v) {
        return new BigIntegerNode(v);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.BIG_INTEGER;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public boolean isIntegralNumber() {
        return true;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean canConvertToInt() {
        return this._value.compareTo(MIN_INTEGER) >= 0 && this._value.compareTo(MAX_INTEGER) <= 0;
    }

    @Override
    public boolean canConvertToLong() {
        return this._value.compareTo(MIN_LONG) >= 0 && this._value.compareTo(MAX_LONG) <= 0;
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        int v;
        if (this.canConvertToInt() && (v = this._value.intValue()) >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
            return (short)v;
        }
        return this._reportShortCoercionRangeFail("shortValue()");
    }

    @Override
    public int intValue() {
        if (this.canConvertToInt()) {
            return this._value.intValue();
        }
        return this._reportIntCoercionRangeFail("intValue()");
    }

    @Override
    public int intValue(int defaultValue) {
        return this.canConvertToInt() ? this._value.intValue() : defaultValue;
    }

    @Override
    public OptionalInt intValueOpt() {
        return this.canConvertToInt() ? OptionalInt.of(this._value.intValue()) : OptionalInt.empty();
    }

    @Override
    public long longValue() {
        if (this.canConvertToLong()) {
            return this._value.longValue();
        }
        return this._reportLongCoercionRangeFail("longValue()");
    }

    @Override
    public long longValue(long defaultValue) {
        if (this.canConvertToLong()) {
            return this._value.longValue();
        }
        return defaultValue;
    }

    @Override
    public OptionalLong longValueOpt() {
        return this.canConvertToLong() ? OptionalLong.of(this._value.longValue()) : OptionalLong.empty();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatCoercionRangeFail("floatValue()");
    }

    @Override
    public double doubleValue() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return this._reportDoubleCoercionRangeFail("doubleValue()");
    }

    @Override
    public double doubleValue(double defaultValue) {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return defaultValue;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return OptionalDouble.of(this._value.doubleValue());
        }
        return OptionalDouble.empty();
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this._value);
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return new BigDecimal(this._value);
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(new BigDecimal(this._value));
    }

    @Override
    public String asString() {
        return this._value.toString();
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return !BigInteger.ZERO.equals(this._value);
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof BigIntegerNode) {
            BigIntegerNode otherNode = (BigIntegerNode)o;
            return Objects.equals(otherNode._value, this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this._value);
    }
}

