/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.std;

import java.util.Collection;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.util.AccessPattern;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;
import tools.jackson.databind.util.NameTransformer;

public class StdConvertingDeserializer<T>
extends StdDeserializer<T> {
    protected final Converter<Object, T> _converter;
    protected final JavaType _delegateType;
    protected final ValueDeserializer<Object> _delegateDeserializer;

    public StdConvertingDeserializer(Converter<?, T> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateDeserializer = null;
    }

    public StdConvertingDeserializer(Converter<Object, T> converter, JavaType delegateType, ValueDeserializer<?> delegateDeserializer) {
        super(delegateType);
        this._converter = converter;
        this._delegateType = delegateType;
        this._delegateDeserializer = delegateDeserializer;
    }

    protected StdConvertingDeserializer(StdConvertingDeserializer<T> src) {
        super(src);
        this._converter = src._converter;
        this._delegateType = src._delegateType;
        this._delegateDeserializer = src._delegateDeserializer;
    }

    protected StdConvertingDeserializer<T> withDelegate(Converter<Object, T> converter, JavaType delegateType, ValueDeserializer<?> delegateDeserializer) {
        ClassUtil.verifyMustOverride(StdConvertingDeserializer.class, this, "withDelegate");
        return new StdConvertingDeserializer<T>(converter, delegateType, delegateDeserializer);
    }

    @Override
    public ValueDeserializer<T> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer unwrapper) {
        ClassUtil.verifyMustOverride(StdConvertingDeserializer.class, this, "unwrappingDeserializer");
        return this.replaceDelegatee(this._delegateDeserializer.unwrappingDeserializer(ctxt, unwrapper));
    }

    @Override
    public ValueDeserializer<T> replaceDelegatee(ValueDeserializer<?> delegatee) {
        ClassUtil.verifyMustOverride(StdConvertingDeserializer.class, this, "replaceDelegatee");
        if (delegatee == this._delegateDeserializer) {
            return this;
        }
        return new StdConvertingDeserializer<T>(this._converter, this._delegateType, delegatee);
    }

    @Override
    public void resolve(DeserializationContext ctxt) {
        if (this._delegateDeserializer != null) {
            this._delegateDeserializer.resolve(ctxt);
        }
    }

    @Override
    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        if (this._delegateDeserializer != null) {
            ValueDeserializer<?> deser = ctxt.handleSecondaryContextualization(this._delegateDeserializer, property, this._delegateType);
            if (deser != this._delegateDeserializer) {
                return this.withDelegate(this._converter, this._delegateType, deser);
            }
            return this;
        }
        JavaType delegateType = this._converter.getInputType(ctxt.getTypeFactory());
        return this.withDelegate(this._converter, delegateType, ctxt.findContextualValueDeserializer(delegateType, property));
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Object delegateValue = this._delegateDeserializer.deserialize(p, ctxt);
        if (delegateValue == null) {
            return null;
        }
        return this.convertValue(delegateValue);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        Object delegateValue = this._delegateDeserializer.deserialize(p, ctxt);
        if (delegateValue == null) {
            return null;
        }
        return this.convertValue(delegateValue);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt, Object intoValue) throws JacksonException {
        if (this._delegateType.getRawClass().isAssignableFrom(intoValue.getClass())) {
            return (T)this._delegateDeserializer.deserialize(p, ctxt, intoValue);
        }
        return (T)this._handleIncompatibleUpdateValue(p, ctxt, intoValue);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer, T intoValue) throws JacksonException {
        if (!this._delegateType.getRawClass().isAssignableFrom(intoValue.getClass())) {
            return this._handleIncompatibleUpdateValue(p, ctxt, intoValue);
        }
        return this._delegateDeserializer.deserialize(p, ctxt, intoValue);
    }

    protected Object _handleIncompatibleUpdateValue(JsonParser p, DeserializationContext ctxt, Object intoValue) throws JacksonException {
        throw new UnsupportedOperationException(String.format("Cannot update object of type %s (using deserializer for type %s)", intoValue.getClass().getName(), this._delegateType));
    }

    @Override
    public Class<?> handledType() {
        return this._delegateDeserializer.handledType();
    }

    @Override
    public LogicalType logicalType() {
        return this._delegateDeserializer.logicalType();
    }

    @Override
    public boolean isCachable() {
        return this._delegateDeserializer != null && this._delegateDeserializer.isCachable();
    }

    @Override
    public ValueDeserializer<?> getDelegatee() {
        return this._delegateDeserializer;
    }

    @Override
    public Collection<Object> getKnownPropertyNames() {
        return this._delegateDeserializer.getKnownPropertyNames();
    }

    @Override
    public T getNullValue(DeserializationContext ctxt) {
        return this._convertIfNonNull(this._delegateDeserializer.getNullValue(ctxt));
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return this._delegateDeserializer.getNullAccessPattern();
    }

    @Override
    public Object getAbsentValue(DeserializationContext ctxt) {
        return this._convertIfNonNull(this._delegateDeserializer.getAbsentValue(ctxt));
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) {
        return this._convertIfNonNull(this._delegateDeserializer.getEmptyValue(ctxt));
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return this._delegateDeserializer.getEmptyAccessPattern();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return this._delegateDeserializer.supportsUpdate(config);
    }

    protected T convertValue(Object delegateValue) {
        return this._converter.convert(delegateValue);
    }

    protected T _convertIfNonNull(Object delegateValue) {
        return delegateValue == null ? null : (T)this._converter.convert(delegateValue);
    }
}

