/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.impl;

import java.lang.annotation.Annotation;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.NullValueProvider;
import tools.jackson.databind.deser.ReadableObjectId;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.UnresolvedForwardReference;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.ObjectIdInfo;

public class ObjectIdReferenceProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    private final SettableBeanProperty _forward;

    public ObjectIdReferenceProperty(SettableBeanProperty forward, ObjectIdInfo objectIdInfo) {
        super(forward);
        this._forward = forward;
        this._objectIdInfo = objectIdInfo;
    }

    public ObjectIdReferenceProperty(ObjectIdReferenceProperty src, ValueDeserializer<?> deser, NullValueProvider nva) {
        super(src, deser, nva);
        this._forward = src._forward;
        this._objectIdInfo = src._objectIdInfo;
    }

    public ObjectIdReferenceProperty(ObjectIdReferenceProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._forward = src._forward;
        this._objectIdInfo = src._objectIdInfo;
    }

    @Override
    public SettableBeanProperty withName(PropertyName newName) {
        return new ObjectIdReferenceProperty(this, newName);
    }

    @Override
    public SettableBeanProperty withValueDeserializer(ValueDeserializer<?> deser) {
        if (this._valueDeserializer == deser) {
            return this;
        }
        NullValueProvider nvp = this._valueDeserializer == this._nullProvider ? deser : this._nullProvider;
        return new ObjectIdReferenceProperty(this, deser, nvp);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nva) {
        return new ObjectIdReferenceProperty(this, this._valueDeserializer, nva);
    }

    @Override
    public void fixAccess(DeserializationConfig config) {
        if (this._forward != null) {
            this._forward.fixAccess(config);
        }
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._forward.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._forward.getMember();
    }

    @Override
    public int getCreatorIndex() {
        return this._forward.getCreatorIndex();
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        this.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        try {
            return this.setAndReturn(ctxt, instance, this.deserialize(p, ctxt));
        }
        catch (UnresolvedForwardReference reference) {
            boolean usingIdentityInfo;
            boolean bl = usingIdentityInfo = this._objectIdInfo != null || this._valueDeserializer.getObjectIdReader(ctxt) != null;
            if (!usingIdentityInfo) {
                throw DatabindException.from(p, "Unresolved forward reference but no identity info", (Throwable)((Object)reference));
            }
            reference.getRoid().appendReferring(new PropertyReferring(this, reference, this._type.getRawClass(), instance));
            return null;
        }
    }

    @Override
    public void set(DeserializationContext ctxt, Object instance, Object value) throws JacksonException {
        this._forward.set(ctxt, instance, value);
    }

    @Override
    public Object setAndReturn(DeserializationContext ctxt, Object instance, Object value) throws JacksonException {
        return this._forward.setAndReturn(ctxt, instance, value);
    }

    public static final class PropertyReferring
    extends ReadableObjectId.Referring {
        private final ObjectIdReferenceProperty _parent;
        public final Object _pojo;

        public PropertyReferring(ObjectIdReferenceProperty parent, UnresolvedForwardReference ref, Class<?> type, Object ob) {
            super(ref, type);
            this._parent = parent;
            this._pojo = ob;
        }

        @Override
        public void handleResolvedForwardReference(DeserializationContext ctxt, Object id, Object value) throws JacksonException {
            if (!this.hasId(id)) {
                throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + String.valueOf(id) + "] that wasn't previously seen as unresolved.");
            }
            this._parent.set(ctxt, this._pojo, value);
        }
    }
}

