/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.impl;

import java.util.Collection;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;

public final class ManagedReferenceProperty
extends SettableBeanProperty.Delegating {
    private static final long serialVersionUID = 1L;
    protected final String _referenceName;
    protected final boolean _isContainer;
    protected final SettableBeanProperty _backProperty;

    public ManagedReferenceProperty(SettableBeanProperty forward, String refName, SettableBeanProperty backward, boolean isContainer) {
        super(forward);
        this._referenceName = refName;
        this._backProperty = backward;
        this._isContainer = isContainer;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty d) {
        throw new IllegalStateException("Should never try to reset delegate");
    }

    @Override
    public void fixAccess(DeserializationConfig config) {
        this.delegate.fixAccess(config);
        this._backProperty.fixAccess(config);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        this.set(ctxt, instance, this.delegate.deserialize(p, ctxt));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        return this.setAndReturn(ctxt, instance, this.deserialize(p, ctxt));
    }

    @Override
    public final void set(DeserializationContext ctxt, Object instance, Object value) {
        this.setAndReturn(ctxt, instance, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object setAndReturn(DeserializationContext ctxt, Object instance, Object value) {
        if (value == null) return this.delegate.setAndReturn(ctxt, instance, value);
        if (this._isContainer) {
            if (value instanceof Object[]) {
                for (Object ob : (Object[])value) {
                    if (ob == null) continue;
                    this._backProperty.set(ctxt, ob, instance);
                }
                return this.delegate.setAndReturn(ctxt, instance, value);
            } else if (value instanceof Collection) {
                for (Object ob : (Collection)value) {
                    if (ob == null) continue;
                    this._backProperty.set(ctxt, ob, instance);
                }
                return this.delegate.setAndReturn(ctxt, instance, value);
            } else {
                if (!(value instanceof Map)) throw new IllegalStateException("Unsupported container type (" + value.getClass().getName() + ") when resolving reference '" + this._referenceName + "'");
                for (Object ob : ((Map)value).values()) {
                    if (ob == null) continue;
                    this._backProperty.set(ctxt, ob, instance);
                }
            }
            return this.delegate.setAndReturn(ctxt, instance, value);
        } else {
            this._backProperty.set(ctxt, value, instance);
        }
        return this.delegate.setAndReturn(ctxt, instance, value);
    }
}

