/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;

public class Gradient
extends Component {
    private final Type type;
    private final String[] color;

    private Gradient(GradientBuilder builder) {
        this.type = builder.type;
        this.color = builder.color;
    }

    @Override
    public String asJavascript() {
        return this.asJSON();
    }

    @Override
    protected Map<String, Object> getJSONContext() {
        return this.getContext();
    }

    @Override
    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("type", (Object)this.type);
        if (this.color != null && this.color.length > 0) {
            if (this.color.length > 1) {
                context.put("color", this.color);
            } else {
                context.put("color", this.color[0]);
            }
        }
        return context;
    }

    public static GradientBuilder builder() {
        return new GradientBuilder();
    }

    public static class GradientBuilder {
        private Type type = Type.NONE;
        private String[] color;

        public GradientBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public GradientBuilder color(String color) {
            this.color = new String[1];
            this.color[0] = color;
            return this;
        }

        public GradientBuilder color(String[] color) {
            this.color = color;
            return this;
        }

        public Gradient build() {
            return new Gradient(this);
        }
    }

    public static enum Type {
        RADIAL("radial"),
        HORIZONTAL("horizontal"),
        VERTICAL("vertical"),
        NONE("none");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

