/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.api;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.plotly.components.Axis;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.traces.ScatterTrace;

public class QQPlot {
    public static Figure create(String title, Table table, String columnName1, String columnName2) {
        NumericColumn xCol = table.nCol(columnName1);
        NumericColumn yCol = table.nCol(columnName2);
        return QQPlot.create(title, xCol.name(), xCol.asDoubleArray(), yCol.name(), yCol.asDoubleArray());
    }

    public static Figure create(String title, String xTitle, double[] xData, String yTitle, double[] yData) {
        Preconditions.checkArgument((xData.length != 0 ? 1 : 0) != 0, (Object)"x Data array is empty");
        Preconditions.checkArgument((yData.length != 0 ? 1 : 0) != 0, (Object)"x Data array is empty");
        if (xData.length != yData.length) {
            double[] interpolatedData;
            if (xData.length < yData.length) {
                interpolatedData = QQPlot.interpolate(yData, xData.length);
                yData = interpolatedData;
            } else {
                interpolatedData = QQPlot.interpolate(xData, yData.length);
                xData = interpolatedData;
            }
        }
        Arrays.sort(xData);
        Arrays.sort(yData);
        double min = Math.min(xData[0], yData[0]);
        double max = Math.max(xData[xData.length - 1], yData[yData.length - 1]);
        double[] line = new double[]{min, max};
        ScatterTrace trace1 = ScatterTrace.builder(line, line).mode(ScatterTrace.Mode.LINE).name("y = x").build();
        ScatterTrace trace2 = ScatterTrace.builder(xData, yData).name("distributions").build();
        Layout layout = Layout.builder().title(title).xAxis(Axis.builder().title(xTitle).build()).yAxis(Axis.builder().title(yTitle).build()).height(700).width(900).build();
        return new Figure(layout, trace1, trace2);
    }

    private static double[] interpolate(double[] source, int size) {
        double[] interpolatedData = new double[size];
        for (int i = 0; i < size; ++i) {
            double value = ((double)i + 0.5) / (double)size * 100.0;
            interpolatedData[i] = StatUtils.percentile((double[])source, (double)value);
        }
        return interpolatedData;
    }
}

