/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.api;

import java.util.List;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.components.Marker;
import tech.tablesaw.plotly.traces.ScatterTrace;
import tech.tablesaw.plotly.traces.Trace;
import tech.tablesaw.table.TableSliceGroup;

public class BubblePlot {
    public static Figure create(String title, Table table, String xCol, String yCol, String sizeColumn, String groupCol) {
        TableSliceGroup tables = table.splitOn(new CategoricalColumn[]{table.categoricalColumn(groupCol)});
        Layout layout = Layout.builder(title, xCol, yCol).showLegend(true).build();
        Trace[] traces = new ScatterTrace[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            List tableList = tables.asTableList();
            Marker marker = Marker.builder().size(((Table)tableList.get(i)).numberColumn(sizeColumn)).build();
            traces[i] = ScatterTrace.builder(((Table)tableList.get(i)).numberColumn(xCol), ((Table)tableList.get(i)).numberColumn(yCol)).showLegend(true).marker(marker).name(((Table)tableList.get(i)).name()).build();
        }
        return new Figure(layout, traces);
    }

    public static Figure create(String title, Column xColumn, Column yColumn, NumericColumn sizeColumn, double[] color, Marker.SizeMode sizeMode, Double opacity) {
        Layout layout = Layout.builder(title, xColumn.name(), yColumn.name()).build();
        Marker marker = null;
        Marker.MarkerBuilder builder = Marker.builder();
        if (sizeColumn != null) {
            builder.size(sizeColumn);
        }
        if (opacity != null) {
            builder.opacity(opacity);
        }
        if (color != null) {
            builder.color(color);
        }
        if (sizeMode != null) {
            builder.sizeMode(sizeMode);
        }
        marker = builder.build();
        ScatterTrace trace = ScatterTrace.builder(xColumn, yColumn).marker(marker).build();
        return new Figure(layout, trace);
    }

    public static Figure create(String title, Table table, String xCol, String yCol, String sizeCol) {
        NumericColumn xColumn = table.numberColumn(xCol);
        NumericColumn yColumn = table.numberColumn(yCol);
        NumericColumn sizeColumn = sizeCol == null ? null : table.numberColumn(sizeCol);
        return BubblePlot.create(title, (Column)xColumn, (Column)yColumn, sizeColumn, null, null, null);
    }

    public static Figure create(String title, String xTitle, double[] xCol, String yTitle, double[] yCol) {
        Layout layout = Layout.builder(title, xTitle, yTitle).build();
        ScatterTrace trace = ScatterTrace.builder(xCol, yCol).build();
        return new Figure(layout, trace);
    }
}

