/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.conversion.TableConverter;
import tech.tablesaw.conversion.smile.SmileConverter;
import tech.tablesaw.io.string.DataFramePrinter;

public abstract class Relation
implements Iterable<Row> {
    public abstract Relation addColumns(Column<?> ... var1);

    public abstract Relation setName(String var1);

    public boolean isEmpty() {
        return this.rowCount() == 0;
    }

    public String shape() {
        return this.name() + ": " + this.rowCount() + " rows X " + this.columnCount() + " cols";
    }

    public Relation removeColumns(int ... columnIndexes) {
        IntArrays.quickSort((int[])columnIndexes, (IntComparator)IntComparators.OPPOSITE_COMPARATOR);
        for (int i : columnIndexes) {
            this.removeColumns(this.column(i));
        }
        return this;
    }

    public abstract Relation removeColumns(Column<?> ... var1);

    public Relation removeColumns(String ... columnName) {
        Column[] cols = new Column[columnName.length];
        for (int i = 0; i < columnName.length; ++i) {
            cols[i] = this.column(columnName[i]);
        }
        this.removeColumns(cols);
        return this;
    }

    public List<Column<?>> columnsOfType(ColumnType type) {
        return this.columns().stream().filter(column -> column.type() == type).collect(Collectors.toList());
    }

    public abstract Table first(int var1);

    public int columnIndex(String columnName) {
        for (int i = 0; i < this.columnCount(); ++i) {
            if (!this.columnNames().get(i).equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column %s is not present in table %s", columnName, this.name()));
    }

    public Column<?> column(String columnName) {
        for (Column<?> column : this.columns()) {
            String name = column.name().trim();
            if (!name.equalsIgnoreCase(columnName)) continue;
            return column;
        }
        throw new IllegalStateException(String.format("Column %s does not exist in table %s", columnName, this.name()));
    }

    public abstract Column<?> column(int var1);

    public abstract int columnCount();

    public abstract int rowCount();

    public abstract List<Column<?>> columns();

    public List<Column<?>> columns(String ... columnName) {
        ArrayList cols = new ArrayList(columnName.length);
        for (String aColumnName : columnName) {
            cols.add(this.column(aColumnName));
        }
        return cols;
    }

    public List<Column<?>> columns(int ... columnIndices) {
        ArrayList cols = new ArrayList(columnIndices.length);
        for (int i : columnIndices) {
            cols.add(this.column(i));
        }
        return cols;
    }

    public abstract int columnIndex(Column<?> var1);

    public Object get(int r, int c) {
        Column<?> column = this.column(c);
        return column.get(r);
    }

    public abstract String name();

    public abstract void clear();

    public abstract List<String> columnNames();

    @Deprecated
    public ColumnType[] columnTypes() {
        ColumnType[] columnTypes = new ColumnType[this.columnCount()];
        for (int i = 0; i < this.columnCount(); ++i) {
            columnTypes[i] = this.columns().get(i).type();
        }
        return columnTypes;
    }

    public ColumnType[] typeArray() {
        ColumnType[] columnTypes = new ColumnType[this.columnCount()];
        for (int i = 0; i < this.columnCount(); ++i) {
            columnTypes[i] = this.columns().get(i).type();
        }
        return columnTypes;
    }

    public List<ColumnType> types() {
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>(this.columnCount());
        for (int i = 0; i < this.columnCount(); ++i) {
            columnTypes.add(this.columns().get(i).type());
        }
        return columnTypes;
    }

    public int[] colWidths() {
        int cols = this.columnCount();
        int[] widths = new int[cols];
        for (int i = 0; i < this.columnCount(); ++i) {
            widths[i] = this.columns().get(i).columnWidth();
        }
        return widths;
    }

    public String toString() {
        return this.print();
    }

    public String printAll() {
        return this.print(this.rowCount());
    }

    public String print(int rowLimit) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataFramePrinter printer = new DataFramePrinter(rowLimit, baos);
        printer.print(this);
        return new String(baos.toByteArray());
    }

    public String print() {
        return this.print(20);
    }

    public Table structure() {
        Table t = Table.create("Structure of " + this.name());
        IntColumn index = IntColumn.indexColumn("Index", this.columnCount(), 0);
        StringColumn columnName = StringColumn.create("Column Name", this.columnCount());
        StringColumn columnType = StringColumn.create("Column Type", this.columnCount());
        t.addColumns(new Column[]{index});
        t.addColumns(new Column[]{columnName});
        t.addColumns(new Column[]{columnType});
        for (int i = 0; i < this.columnCount(); ++i) {
            Column<?> column = this.columns().get(i);
            columnType.set(i, column.type().name());
            columnName.set(i, this.columnNames().get(i));
        }
        return t;
    }

    public Table summary() {
        Table summaryTable = Table.create(this.name());
        if (this.columnCount() == 0) {
            return summaryTable;
        }
        summaryTable.addColumns(new Column[]{StringColumn.create("Measure")});
        for (int i = 0; i < this.columnCount(); ++i) {
            Table columnSummary = this.column(i).summary();
            columnSummary.column(1).setName(this.column(i).name());
            summaryTable = summaryTable.joinOn("Measure").fullOuter(columnSummary, columnSummary.column(0).name());
        }
        summaryTable.column(0).setName("Summary");
        return summaryTable;
    }

    public BooleanColumn booleanColumn(int columnIndex) {
        return (BooleanColumn)this.column(columnIndex);
    }

    public BooleanColumn booleanColumn(String columnName) {
        return (BooleanColumn)this.column(columnName);
    }

    public NumericColumn<?> numberColumn(int columnIndex) {
        Column<?> c = this.column(columnIndex);
        if (c.type() == ColumnType.STRING) {
            return ((StringColumn)c).asDoubleColumn();
        }
        if (c.type() == ColumnType.BOOLEAN) {
            return ((BooleanColumn)c).asDoubleColumn();
        }
        if (c.type() == ColumnType.LOCAL_DATE) {
            return ((DateColumn)c).asDoubleColumn();
        }
        if (c.type() == ColumnType.LOCAL_DATE_TIME) {
            return ((DateTimeColumn)c).asDoubleColumn();
        }
        if (c.type() == ColumnType.INSTANT) {
            return ((InstantColumn)c).asDoubleColumn();
        }
        if (c.type() == ColumnType.LOCAL_TIME) {
            return ((TimeColumn)c).asDoubleColumn();
        }
        return (NumericColumn)this.column(columnIndex);
    }

    public NumericColumn<?> numberColumn(String columnName) {
        return this.numberColumn(this.columnIndex(columnName));
    }

    public DoubleColumn doubleColumn(String columnName) {
        return this.doubleColumn(this.columnIndex(columnName));
    }

    public DoubleColumn doubleColumn(int columnIndex) {
        return (DoubleColumn)this.column(columnIndex);
    }

    public StringColumn[] stringColumns() {
        return (StringColumn[])this.columns().stream().filter(e -> e.type() == ColumnType.STRING).toArray(StringColumn[]::new);
    }

    public NumericColumn<?>[] numberColumns() {
        return (NumericColumn[])this.columns().stream().filter(e -> e instanceof NumericColumn).toArray(NumericColumn[]::new);
    }

    public List<NumericColumn<?>> numericColumns() {
        return Arrays.asList(this.numberColumns());
    }

    public List<NumericColumn<?>> numericColumns(int ... columnIndices) {
        ArrayList cols = new ArrayList();
        for (int i : columnIndices) {
            cols.add(this.numberColumn(i));
        }
        return cols;
    }

    public List<NumericColumn<?>> numericColumns(String ... columnNames) {
        ArrayList cols = new ArrayList();
        for (String name : columnNames) {
            cols.add(this.numberColumn(name));
        }
        return cols;
    }

    public BooleanColumn[] booleanColumns() {
        return (BooleanColumn[])this.columns().stream().filter(e -> e.type() == ColumnType.BOOLEAN).toArray(BooleanColumn[]::new);
    }

    public DateColumn[] dateColumns() {
        return (DateColumn[])this.columns().stream().filter(e -> e.type() == ColumnType.LOCAL_DATE).toArray(DateColumn[]::new);
    }

    public DateTimeColumn[] dateTimeColumns() {
        return (DateTimeColumn[])this.columns().stream().filter(e -> e.type() == ColumnType.LOCAL_DATE_TIME).toArray(DateTimeColumn[]::new);
    }

    public InstantColumn[] instantColumns() {
        return (InstantColumn[])this.columns().stream().filter(e -> e.type() == ColumnType.INSTANT).toArray(InstantColumn[]::new);
    }

    public TimeColumn[] timeColumns() {
        return (TimeColumn[])this.columns().stream().filter(e -> e.type() == ColumnType.LOCAL_TIME).toArray(TimeColumn[]::new);
    }

    public CategoricalColumn<?> categoricalColumn(String columnName) {
        return (CategoricalColumn)this.column(columnName);
    }

    public CategoricalColumn<?> categoricalColumn(int columnNumber) {
        return (CategoricalColumn)this.column(columnNumber);
    }

    public List<CategoricalColumn<?>> categoricalColumns(String ... columnName) {
        ArrayList cols = new ArrayList(columnName.length);
        for (String aColumnName : columnName) {
            cols.add(this.categoricalColumn(aColumnName));
        }
        return cols;
    }

    public NumericColumn<?> nCol(String columnName) {
        return this.numberColumn(columnName);
    }

    public NumericColumn<?> nCol(int columnIndex) {
        return this.numberColumn(columnIndex);
    }

    public IntColumn intColumn(String columnName) {
        return this.intColumn(this.columnIndex(columnName));
    }

    public IntColumn intColumn(int columnIndex) {
        return (IntColumn)this.column(columnIndex);
    }

    public ShortColumn shortColumn(String columnName) {
        return this.shortColumn(this.columnIndex(columnName));
    }

    public ShortColumn shortColumn(int columnIndex) {
        return (ShortColumn)this.column(columnIndex);
    }

    public LongColumn longColumn(String columnName) {
        return this.longColumn(this.columnIndex(columnName));
    }

    public LongColumn longColumn(int columnIndex) {
        return (LongColumn)this.column(columnIndex);
    }

    public FloatColumn floatColumn(String columnName) {
        return this.floatColumn(this.columnIndex(columnName));
    }

    public FloatColumn floatColumn(int columnIndex) {
        return (FloatColumn)this.column(columnIndex);
    }

    public DateColumn dateColumn(int columnIndex) {
        return (DateColumn)this.column(columnIndex);
    }

    public DateColumn dateColumn(String columnName) {
        return (DateColumn)this.column(columnName);
    }

    public TimeColumn timeColumn(String columnName) {
        return (TimeColumn)this.column(columnName);
    }

    public TimeColumn timeColumn(int columnIndex) {
        return (TimeColumn)this.column(columnIndex);
    }

    public StringColumn stringColumn(String columnName) {
        return (StringColumn)this.column(columnName);
    }

    public StringColumn stringColumn(int columnIndex) {
        return (StringColumn)this.column(columnIndex);
    }

    public TextColumn textColumn(String columnName) {
        return (TextColumn)this.column(columnName);
    }

    public TextColumn textColumn(int columnIndex) {
        return (TextColumn)this.column(columnIndex);
    }

    public DateTimeColumn dateTimeColumn(int columnIndex) {
        return (DateTimeColumn)this.column(columnIndex);
    }

    public DateTimeColumn dateTimeColumn(String columnName) {
        return (DateTimeColumn)this.column(columnName);
    }

    public InstantColumn instantColumn(int columnIndex) {
        return (InstantColumn)this.column(columnIndex);
    }

    public InstantColumn instantColumn(String columnName) {
        return (InstantColumn)this.column(columnName);
    }

    public TableConverter as() {
        return new TableConverter(this);
    }

    public SmileConverter smile() {
        return new SmileConverter(this);
    }

    public String getUnformatted(int r, int c) {
        Column<?> column = this.column(c);
        return column.getUnformattedString(r);
    }

    public String getString(int r, String columnName) {
        return this.getString(r, this.columnIndex(columnName));
    }

    public String getString(int r, int columnIndex) {
        Column<?> column = this.column(columnIndex);
        return column.getString(r);
    }

    public boolean containsColumn(Column<?> column) {
        return this.columns().contains(column);
    }

    public boolean containsColumn(String columnName) {
        String lowerCase = columnName.toLowerCase();
        return this.columnNames().stream().anyMatch(e -> e.toLowerCase().equals(lowerCase));
    }
}

